/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ExecuteException;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Fire
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "fire";

    public Fire() {
        this.aliases.add("run");
    }

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        long count = 0L;
        if (params != null && params.length == 1) {
            long fc = params[0].getValue(engine).implicitCast(JamochaType.LONG).getLongValue();
            try {
                Logging.logger(this.getClass()).debug("Start firing " + fc + " times");
                count = engine.fire((int)fc);
                Logging.logger(this.getClass()).debug("finished firing");
            }
            catch (ExecuteException e) {
                throw new EvaluationException(e);
            }
        }
        try {
            Logging.logger(this.getClass()).debug("Start firing (unbounded)");
            count = engine.fire();
            Logging.logger(this.getClass()).debug("finished firing");
        }
        catch (ExecuteException e) {
            throw new EvaluationException("Error during fire. ", e);
        }
        return JamochaValue.newLong(count);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Starts the execution of rules. If the optional argument is positive, execution will cease after the specified number of rule firings or when the agenda contains no more rule activations. If there are no arguments or the argument is a negative integer, execution will cease when the agenda contains no more rule activations. If the focus stack is empty the MAIN module is automatically in the current focus. Returns the number of rules fired.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Number of rules to fire at most.";
        }

        public String getParameterName(int parameter) {
            return "ruleCount";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.LONGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LONGS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return true;
        }

        public String getExample() {
            return "(fire)\n(fire 7)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

