/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class FactSlotValue
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "fact-slot-value";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 2) {
            JamochaValue factId = params[0].getValue(engine);
            JamochaValue slotName = params[1].getValue(engine);
            Fact fact = !factId.is(JamochaType.FACT) ? engine.getFactById(factId.implicitCast(JamochaType.FACT_ID)) : factId.getFactValue();
            int slotId = fact.getSlotId(slotName.getIdentifierValue());
            if (slotId < 0) {
                throw new EvaluationException("Error no slot " + slotName);
            }
            return fact.getSlotValue(slotId);
        }
        throw new IllegalParameterException(2);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the value of a slot of a specific fact.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Fact to return the slot value from.";
                }
                case 1: {
                    return "Name of the slot to get the value from.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "fact";
                }
                case 1: {
                    return "slotName";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    int i;
                    JamochaType[] paramTypes = new JamochaType[JamochaType.FACTS.length + JamochaType.FACT_IDS.length];
                    int count = 0;
                    for (i = 0; i < JamochaType.FACTS.length; ++i) {
                        paramTypes[count++] = JamochaType.FACTS[i];
                    }
                    for (i = 0; i < JamochaType.FACT_IDS.length; ++i) {
                        paramTypes[count++] = JamochaType.FACT_IDS[i];
                    }
                    return paramTypes;
                }
                case 1: {
                    return JamochaType.IDENTIFIERS;
                }
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.ANY;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate car (slot color)(slot speed))\n(assert (car (color \"red\")(speed 200)))\n(assert (car (color \"blue\")(speed 150)))\n(assert (car (color \"green\")(speed 100)))\n(fact-slot-value 3 color)\n";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "blue";
        }
    }
}

