/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalConversionException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class FactId
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new FindFactByFactDescription();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "fact-id";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 1) {
            JamochaValue param = params[0].getValue(engine);
            try {
                long factId = param.is(JamochaType.IDENTIFIER) && param.getStringValue().length() > 2 && param.getStringValue().startsWith("f-") ? Long.parseLong(param.getStringValue().substring(2)) : param.implicitCast(JamochaType.LONG).getLongValue();
                Fact fact = engine.getFactById(factId);
                if (fact == null) {
                    return JamochaValue.NIL;
                }
                return JamochaValue.newFact(fact);
            }
            catch (IllegalConversionException e) {
                throw new IllegalTypeException(DESCRIPTION.getParameterTypes(0), param.getType());
            }
        }
        throw new IllegalParameterException(1);
    }

    private static final class FindFactByFactDescription
    implements FunctionDescription {
        private FindFactByFactDescription() {
        }

        public String getDescription() {
            return "Returns the value (fact) of the given fact-id or NIL if the given id doesn't exist.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Fact-Id to get fact from.";
        }

        public String getParameterName(int parameter) {
            return "factId";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            int i;
            JamochaType[] paramTypes = new JamochaType[JamochaType.LONGS.length + JamochaType.FACT_IDS.length];
            int count = 0;
            for (i = 0; i < JamochaType.LONGS.length; ++i) {
                paramTypes[count++] = JamochaType.LONGS[i];
            }
            for (i = 0; i < JamochaType.FACT_IDS.length; ++i) {
                paramTypes[count++] = JamochaType.FACT_IDS[i];
            }
            return paramTypes;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.FACTS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate car (slot color)(slot speed))\n(assert (car (color \"red\")(speed 200)))\n(assert (car (color \"blue\")(speed 150)))\n(assert (car (color \"green\")(speed 100)))\n(fact-id 2)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

