/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.JavaTemplate;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class DeftemplateFromJavaClass
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "deftemplate-from-javaclass";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        Logging.JamochaLogger log = Logging.logger(this.getClass());
        if (params != null && params.length == 2) {
            Class<?> cls;
            boolean beanStyle = params[0].getValue(engine).getBooleanValue();
            String javaClass = params[1].getValue(engine).getStringValue();
            if (!beanStyle) {
                log.warn("The 'public attributes' way of interpreting a java class as template is not implemented anymore. Using Beans is the recommended and supported way!");
                return JamochaValue.FALSE;
            }
            log.debug("Trying to generate deftemplate from '" + javaClass + "'" + (beanStyle ? " by bean attributes" : " directly by public members"));
            Template t = engine.getCurrentFocus().getTemplate(javaClass);
            if (t != null) {
                log.warn("a deftemplate '" + javaClass + "' already exists");
                return JamochaValue.FALSE;
            }
            try {
                cls = Class.forName(javaClass, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                log.warn("class '" + javaClass + "' not found");
                engine.writeMessage("class not found");
                return JamochaValue.FALSE;
            }
            log.debug("found class '" + javaClass + "'");
            JavaTemplate newTmpl = new JavaTemplate(cls);
            if (engine.addTemplate(newTmpl)) {
                log.debug("deftemplate '" + newTmpl.getName() + "' successfully defined");
                return JamochaValue.TRUE;
            }
            log.warn("error while defining deftemplate '" + cls.getName() + "'");
            return JamochaValue.FALSE;
        }
        throw new IllegalParameterException(1);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Defines a new template out of a Java class.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Whether this function should use the getter/setter-defined values (true) or simply the public attributes (false)";
                }
                case 1: {
                    return "The fully qualified java class name";
                }
            }
            return null;
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "bean-style";
                }
                case 1: {
                    return "classname";
                }
            }
            return null;
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.BOOLEANS;
                }
                case 1: {
                    return JamochaType.STRINGS;
                }
            }
            return null;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate-from-javaclass true org.jamocha.jsr94.test.Wurst)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

