/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Deftemplate
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "deftemplate";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params != null && params.length == 1) {
            JamochaValue firstParam = params[0].getValue(engine);
            if (firstParam.getObjectValue() instanceof org.jamocha.engine.workingmemory.elements.Deftemplate) {
                org.jamocha.engine.workingmemory.elements.Deftemplate tpl = (org.jamocha.engine.workingmemory.elements.Deftemplate)firstParam.getObjectValue();
                result = engine.addTemplate(tpl) ? JamochaValue.TRUE : JamochaValue.FALSE;
            }
        } else {
            throw new IllegalParameterException(1);
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Defines a new template in the currently focused module of the engine.\nA template has the following syntax:\n(deftemplate templ\t\t;name of deftemplate relation\n\t\"comment\"\t\t\t;optional comment in quotes\n\t(slot slot1name\t\t;name of 1st field\n\t(type STRING)\t\t;type of field (optional)\n\t(default ?someVar))\t;default value of 1st field (optional)\n\t(slot slot2name\t\t;name of 2nd field\n\t(type SYMBOL))\t\t;type of field\n\t\t...\n)\t\t\t\t\t\t;close deftemplate";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Template to be defined.";
        }

        public String getParameterName(int parameter) {
            return "template";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.OBJECTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate transact\n  (slot accountId (type STRING))\n  (slot countryCode (type STRING))\n  (slot currentPrice (type DOUBLE))\n  (slot issuer (type STRING))\n  (slot lastPrice (type DOUBLE))\n  (slot purchaseDate (type STRING))\n  (slot total (type DOUBLE))\n)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

