/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Apply
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "apply";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params == null || params.length < 1) {
            throw new IllegalParameterException(1);
        }
        String functionName = params[0].getValue(engine).getStringValue();
        Signature func = new Signature(functionName);
        Parameter[] functionParams = new Parameter[params.length - 1];
        System.arraycopy(params, 1, functionParams, 0, functionParams.length);
        func.setParameters(functionParams);
        JamochaValue result = func.getValue(engine);
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Applies a given function to one or more given arguments.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            if (parameter > 0) {
                return "Optional parameters for the function.";
            }
            return "Name of the function to apply.";
        }

        public String getParameterName(int parameter) {
            if (parameter > 0) {
                return "functionParameter";
            }
            return "functionName";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            if (parameter > 0) {
                return JamochaType.ANY;
            }
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.ANY;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(apply add 17 4)\n(apply explode$ \"My name is not earl.\" ' not ')";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

