/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.math;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Max
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "max";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            JamochaValue result = params[0].getValue(engine);
            for (int idx = 1; idx < params.length; ++idx) {
                JamochaValue value = params[idx].getValue(engine);
                if (result.is(JamochaType.DOUBLE)) {
                    if (!(result.getDoubleValue() < value.implicitCast(JamochaType.DOUBLE).getDoubleValue())) continue;
                    result = value;
                    continue;
                }
                if (result.is(JamochaType.LONG)) {
                    if (result.getLongValue() >= value.implicitCast(JamochaType.LONG).getLongValue()) continue;
                    result = value;
                    continue;
                }
                throw new IllegalTypeException(JamochaType.NUMBERS, result.getType());
            }
            return result;
        }
        throw new IllegalParameterException(1, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the value of its greatest numeric argument. Each argument has to be a numeric expression. The return type is either an integer or float depending on the type of the greatest argument.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Numeric values (at least one) to get the maximum from.";
        }

        public String getParameterName(int parameter) {
            return "number";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NUMBERS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(max 87 -.3 777 445 9023 -75555)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return 9023;
        }
    }
}

