/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.math;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Divide
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "divide";

    public Divide() {
        this.aliases.add("/");
    }

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            boolean isDouble = false;
            for (int idx = 0; idx < params.length; ++idx) {
                if (!params[idx].getValue(engine).getType().equals((Object)JamochaType.DOUBLE)) continue;
                isDouble = true;
                break;
            }
            if (isDouble) {
                double result = params[0].getValue(engine).implicitCast(JamochaType.DOUBLE).getDoubleValue();
                for (int i = 1; i < params.length; ++i) {
                    result /= params[i].getValue(engine).implicitCast(JamochaType.DOUBLE).getDoubleValue();
                }
                return JamochaValue.newDouble(result);
            }
            long result = params[0].getValue(engine).implicitCast(JamochaType.LONG).getLongValue();
            for (int i = 1; i < params.length; ++i) {
                result /= params[i].getValue(engine).implicitCast(JamochaType.LONG).getLongValue();
            }
            return JamochaValue.newLong(result);
        }
        throw new IllegalParameterException(1, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the value of the first argument divided by each of the subsequent arguments. This function can be called with the identifier 'divide' or '/'.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            if (parameter == 0) {
                return "Numeric value which is divided by the following arguments.";
            }
            return "Numeric values which divide the first argument or the result of the previous divisions respectively.";
        }

        public String getParameterName(int parameter) {
            if (parameter == 0) {
                return "dividend";
            }
            return "divisor";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NUMBERS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(/ 27 3 -4.5)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return -2.0;
        }
    }
}

