/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.math;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Cosh
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "cosh";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 1) {
            JamochaValue value = params[0].getValue(engine);
            if (!value.getType().equals((Object)JamochaType.DOUBLE) && !value.getType().equals((Object)JamochaType.LONG)) {
                value = value.implicitCast(JamochaType.DOUBLE);
            }
            if (value.getType().equals((Object)JamochaType.DOUBLE)) {
                return JamochaValue.newDouble(Math.cosh(value.getDoubleValue()));
            }
            if (value.getType().equals((Object)JamochaType.LONG)) {
                return JamochaValue.newDouble(Math.cosh(value.getLongValue()));
            }
        }
        throw new IllegalParameterException(1);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the hyperbolic cosine of a numeric argument. The hyperbolic cosine of x is defined to be (e^x + e^(-x))/2 where e is Euler's number.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Numeric value to get the hyperbolic cosine from.";
        }

        public String getParameterName(int parameter) {
            return "number";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.DOUBLES;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(cosh -0.08646678676)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return Math.cosh(-0.08646678676);
        }
    }
}

