/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.math;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Add
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "add";

    public Add() {
        this.aliases.add("+");
    }

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            boolean isDouble = false;
            for (int idx = 0; idx < params.length; ++idx) {
                if (!params[idx].getValue(engine).getType().equals((Object)JamochaType.DOUBLE)) continue;
                isDouble = true;
                break;
            }
            if (isDouble) {
                double result = 0.0;
                for (int i = 0; i < params.length; ++i) {
                    result += params[i].getValue(engine).implicitCast(JamochaType.DOUBLE).getDoubleValue();
                }
                return JamochaValue.newDouble(result);
            }
            long result = 0L;
            for (int i = 0; i < params.length; ++i) {
                result += params[i].getValue(engine).implicitCast(JamochaType.LONG).getLongValue();
            }
            return JamochaValue.newLong(result);
        }
        throw new IllegalParameterException(1, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the sum of its numeric arguments. This function can be called with the identifier 'add' or '+'. Each argument has to be a numeric expression. The return type depends on the types of the arguments, it returns a double if any of its arguments is a double, otherwise it returns a long.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Numeric values (at least one) to be added up.";
        }

        public String getParameterName(int parameter) {
            return "number";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NUMBERS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(+ 7 8.56 -4.3)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

