/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import java.util.LinkedList;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Union$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "union$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            LinkedList<JamochaValue> tmpList = new LinkedList<JamochaValue>();
            for (int i = 0; i < params.length; ++i) {
                JamochaValue list = params[i].getValue(engine);
                if (list.is(JamochaType.LIST)) {
                    for (int j = 0; j < list.getListCount(); ++j) {
                        JamochaValue current = list.getListValue(j);
                        if (tmpList.contains(current)) continue;
                        tmpList.add(current);
                    }
                    continue;
                }
                if (list.is(JamochaType.NIL)) continue;
                throw new IllegalTypeException(JamochaType.LISTS, list.getType());
            }
            JamochaValue[] res = new JamochaValue[tmpList.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (JamochaValue)tmpList.get(i);
            }
            return JamochaValue.newList(res);
        }
        throw new IllegalParameterException(1, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the union of its arguments without duplicates.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "List to unify with the other arguments.";
        }

        public String getParameterName(int parameter) {
            return "list";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.LISTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LISTS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(union$ (create$ a b c) (create$ e d a f) (create$ 1 2 d))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "[a, b, c, e, d, f, 1, 2]";
        }
    }
}

