/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Subsetp
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "subsetp";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 2) {
            JamochaValue first = params[0].getValue(engine);
            JamochaValue second = params[1].getValue(engine);
            if (!first.getType().equals((Object)JamochaType.LIST)) {
                throw new IllegalTypeException(JamochaType.LISTS, first.getType());
            }
            if (!second.getType().equals((Object)JamochaType.LIST)) {
                throw new IllegalTypeException(JamochaType.LISTS, second.getType());
            }
            if (first.equals(JamochaValue.EMPTY_LIST)) {
                return JamochaValue.TRUE;
            }
            if (second.getListCount() >= first.getListCount()) {
                block0: for (int i = 0; i < first.getListCount(); ++i) {
                    for (int j = 0; j < second.getListCount(); ++j) {
                        if (first.getListValue(i).equals(second.getListValue(j))) continue block0;
                    }
                    return JamochaValue.FALSE;
                }
                return JamochaValue.TRUE;
            }
            return JamochaValue.FALSE;
        }
        throw new IllegalParameterException(2, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns true if the first list is a subset of the second list, false otherwise. The order of the lists is not considered.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Subset to test for.";
                }
                case 1: {
                    return "List to search in.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "listOne";
                }
                case 1: {
                    return "listTwo";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.LISTS;
                }
                case 1: {
                    return JamochaType.LISTS;
                }
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(subsetp (create$ 3 4) (create$ 1 2 3 4 5 6))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return JamochaValue.TRUE;
        }
    }
}

