/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import java.util.LinkedList;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Intersection$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "intersection$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 2) {
            JamochaValue firstList = params[0].getValue(engine);
            JamochaValue secondList = params[1].getValue(engine);
            if (!firstList.is(JamochaType.LIST)) {
                throw new IllegalTypeException(JamochaType.LISTS, firstList.getType());
            }
            if (!secondList.is(JamochaType.LIST)) {
                throw new IllegalTypeException(JamochaType.LISTS, secondList.getType());
            }
            LinkedList<JamochaValue> tmpList = new LinkedList<JamochaValue>();
            block0: for (int i = 0; i < firstList.getListCount(); ++i) {
                JamochaValue current = firstList.getListValue(i);
                if (tmpList.contains(current)) continue;
                for (int j = 0; j < secondList.getListCount(); ++j) {
                    if (!current.equals(secondList.getListValue(j))) continue;
                    tmpList.add(current);
                    continue block0;
                }
            }
            JamochaValue[] res = new JamochaValue[tmpList.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (JamochaValue)tmpList.get(i);
            }
            return JamochaValue.newList(res);
        }
        throw new IllegalParameterException(1, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the intersection of its two arguments without duplicates. The order of returned items corresponds to the one in the first list. ";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "First list for intersection.";
                }
                case 1: {
                    return "Second list for intersection.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "firstList";
                }
                case 1: {
                    return "secondList";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.LISTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LISTS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(intersection$ (create$ 3 a b 1 c) (create$ e 1 d a f c))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "[a, 1, c]";
        }
    }
}

