/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import java.util.LinkedList;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class DeleteMember$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "delete-member$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 1) {
            JamochaValue subject = params[0].getValue(engine);
            if (subject.is(JamochaType.LIST)) {
                int i;
                LinkedList<JamochaValue> tmpList = new LinkedList<JamochaValue>();
                LinkedList<JamochaValue> searchValues = new LinkedList<JamochaValue>();
                for (i = 0; i < subject.getListCount(); ++i) {
                    tmpList.add(subject.getListValue(i));
                }
                for (i = 1; i < params.length; ++i) {
                    searchValues.add(params[i].getValue(engine));
                }
                int startIndex = 0;
                while (startIndex < tmpList.size()) {
                    boolean found = false;
                    block3: for (JamochaValue searchValue : searchValues) {
                        if (searchValue.is(JamochaType.LIST)) {
                            int i2;
                            if (searchValue.getListCount() > tmpList.size() - startIndex) continue;
                            for (i2 = 0; i2 < searchValue.getListCount(); ++i2) {
                                if (!((JamochaValue)tmpList.get(startIndex + i2)).equals(searchValue.getListValue(i2))) continue block3;
                            }
                            for (i2 = 0; i2 < searchValue.getListCount(); ++i2) {
                                tmpList.remove(startIndex);
                            }
                            found = true;
                            break;
                        }
                        if (!((JamochaValue)tmpList.get(startIndex)).equals(searchValue)) continue;
                        found = true;
                        tmpList.remove(startIndex);
                        break;
                    }
                    if (!found) {
                        ++startIndex;
                        continue;
                    }
                    startIndex = 0;
                }
                JamochaValue[] res = new JamochaValue[tmpList.size()];
                for (int i3 = 0; i3 < res.length; ++i3) {
                    res[i3] = (JamochaValue)tmpList.get(i3);
                }
                return JamochaValue.newList(res);
            }
            throw new IllegalTypeException(JamochaType.LISTS, subject.getType());
        }
        throw new IllegalParameterException(2, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Deletes specific items from a list. Arguments can either be single items or lists of items.\nIn case of a list to be deleted, items are only removed if they appear in identical (correct and coherent) order in the first list. The function walks through the first list and tries to match each position to any of the arguments that are to be deleted. After deleting items from the list, it starts anew to walk through the remaining list and tries again to find a match to any of the arguments that are to be deleted. Therefore the arguments are not necessarily processed in the order they are given and also deleted repeatedly if the remaining list can be matched again.\nReturns a new list consisting of the remaining items.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "List to delete items from.";
                }
                case 1: {
                    return "Item(s) to delete from the list.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "someList";
                }
                case 1: {
                    return "deleteItem";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.LISTS;
                }
                case 1: {
                    return JamochaType.ANY;
                }
            }
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LISTS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 1;
        }

        public String getExample() {
            return "(delete-member$ (create$ 1 2 3 4 5) 2)\n(delete-member$ (create$ 1 2 3 4 5) (create$ 3 4) 1)\n(delete-member$ (create$ 1 2 3 4 5) (create$ 3 4) (create$ 2 5))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "[1]";
        }
    }
}

