/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.java;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassnameResolver {
    private final List<String> packages = new ArrayList<String>();
    private final List<String> classes = new ArrayList<String>();
    private static final Pattern classnamePattern = Pattern.compile("([\\w_][\\w_\\d]*\\.)*([\\w_][\\w_\\d]*)");
    private static final Pattern packagePattern = Pattern.compile("([\\w_][\\w_\\d]*\\.)+\\*");

    public ClassnameResolver() {
        this.packages.add("java.lang.*");
    }

    public void addImport(String s) throws ClassNotFoundException {
        if (classnamePattern.matcher(s).matches()) {
            this.classes.add(s);
        } else if (packagePattern.matcher(s).matches()) {
            this.packages.add(s);
        } else {
            throw new ClassNotFoundException("The import \"" + s + "\" is neither a valid class nor package name.");
        }
    }

    public Class<?> resolveClass(String name) throws ClassNotFoundException {
        if (!this.isValidClassname(name)) {
            throw new ClassNotFoundException("\"" + name + "\" is not a valid class name.");
        }
        ArrayList<String> possibleNames = new ArrayList<String>();
        possibleNames.add(name);
        if (!this.isQualifiedClassname(name)) {
            for (String className : this.classes) {
                Matcher matcher = classnamePattern.matcher(className);
                if (!matcher.group(2).equals(name)) continue;
                possibleNames.add(className);
            }
            for (String packageName : this.packages) {
                possibleNames.add(packageName.replace("*", name));
            }
        }
        for (String possibleClassName : possibleNames) {
            try {
                return Class.forName(possibleClassName);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException("Class \"" + name + "\" could ot be found.");
    }

    public boolean isValidClassname(String s) {
        Matcher matcher = classnamePattern.matcher(s);
        return matcher.matches();
    }

    public boolean isQualifiedClassname(String s) {
        return this.isValidClassname(s) && s.contains(".");
    }
}

