/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.io;

import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Printout
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "printout";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.NIL;
        if (params.length > 0) {
            String outputType = params[0].getValue(engine).getStringValue();
            JamochaValue value = null;
            StringBuilder outputString = new StringBuilder();
            for (int idx = 1; idx < params.length; ++idx) {
                value = params[idx].getValue(engine);
                if (value != null) {
                    String str = value.toString();
                    if (str.equalsIgnoreCase("crlf")) {
                        outputString.append(Constants.LINEBREAK);
                        continue;
                    }
                    outputString.append(str);
                    continue;
                }
                outputString.append(" <NIL> ");
            }
            engine.writeMessage(outputString.toString(), outputType);
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Writes any number and type of arguments to the channel specified in the first argument. 't' indicates to send the output to the standard output device of the computer. Generally, this is the terminal. Printout concatenates all arguments after the channel without separation marks. A string, enclosed in double quotes, is handled as one single argument.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Any value to print out.";
        }

        public String getParameterName(int parameter) {
            return "value";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(printout t \"Jamocha rul\" e z !)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return JamochaValue.NIL;
        }
    }
}

