/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.datetime;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Timestamp2Datetime
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "timestamp2datetime";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 1) {
            long p1 = params[0].getValue(engine).getLongValue();
            GregorianCalendar foo = new GregorianCalendar();
            foo.setTimeZone(TimeZone.getTimeZone("UTC"));
            foo.setTimeInMillis(p1);
            return JamochaValue.newDate(foo);
        }
        throw new IllegalParameterException(1, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the DateTime-Object of the given Timestamp argument.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Timestamp to convert into a Datetime-Object.";
        }

        public String getParameterName(int parameter) {
            return "timestamp";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.LONGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.DATETIMES;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(timestamp2datetime 293196017000)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "1979-04-17 11:20:17+00";
        }
    }
}

