/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.compare;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class GreaterOrEqual
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "greaterOrEqual";

    public GreaterOrEqual() {
        this.aliases.add(">=");
    }

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            JamochaValue previous = params[0].getValue(engine);
            boolean isDouble = previous.is(JamochaType.DOUBLE);
            for (int i = 1; i < params.length; ++i) {
                JamochaValue current = params[i].getValue(engine);
                if (current.is(JamochaType.DOUBLE)) {
                    isDouble = true;
                }
                if (isDouble ? current.getDoubleValue() > previous.getDoubleValue() : current.getLongValue() > previous.getLongValue()) {
                    return JamochaValue.FALSE;
                }
                previous = current;
            }
            return JamochaValue.TRUE;
        }
        throw new IllegalParameterException(1, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "GreaterOrEqual will compare two or more numeric values and return true, if the (n-1)th value is greater than or equal to the nth value.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            return "Number that will be compared to the other parameters.";
        }

        public String getParameterName(int parameter) {
            return "number";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(greaterOrEqual 84 2 2 1)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return JamochaValue.TRUE;
        }
    }
}

