/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.agent;

import jade.core.AID;
import jade.lang.acl.ACLMessage;
import java.util.Date;
import org.jamocha.communication.agent.JamochaAgent;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class AgentSearchFunction
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "agent-search";
    private final JamochaAgent agent;
    private StringChannel channel;
    public String output = "t";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public AgentSearchFunction(JamochaAgent agent) {
        this.agent = agent;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        this.channel = this.agent.getEngine().getMessageRouter().openChannel(this.agent.getProperties().getProperty("agent.name", "Agent"));
        if (params.length != 3) {
            if (params.length == 1) {
                if (params[0].getValue(engine).is(JamochaType.FACT)) {
                    Fact answer = params[0].getValue(engine).getFactValue();
                    if (this.checkanswer(answer, engine)) {
                        engine.writeMessage("true", this.output);
                        return JamochaValue.TRUE;
                    }
                    engine.writeMessage("false", this.output);
                    return JamochaValue.FALSE;
                }
                this.channel.executeCommand("(printout " + this.output + " false)");
                return JamochaValue.FALSE;
            }
            throw new EvaluationException("Search needs, and only needs DF(s) the own AID and SD(s) or DF-AD(s) you want to yearch for");
        }
        JamochaValue aid = params[1].getValue(engine);
        if (!aid.is(JamochaType.STRING)) {
            throw new EvaluationException("AID must to be a String (Name)");
        }
        String sender = aid.getStringValue();
        sender = sender.substring(1, sender.length() - 1);
        JamochaValue df = params[0].getValue(engine);
        if (df.is(JamochaType.STRING)) {
            String df2 = df.getStringValue();
            df2 = df2.substring(1, df2.length() - 1);
            JamochaValue sd = params[2].getValue(engine);
            if (this.checkServiceAndSend(sd, df2, sender, engine)) {
                return JamochaValue.newString("");
            }
            throw new EvaluationException("Error during sending messages");
        }
        if (df.is(JamochaType.LIST)) {
            int i = 0;
            if (i < df.getListCount()) {
                String df2 = df.getStringValue();
                df2 = df2.substring(1, df2.length() - 1);
                JamochaValue sd = params[3].getValue(engine);
                if (this.checkServiceAndSend(sd, df2, sender, engine)) {
                    return JamochaValue.newString("");
                }
                throw new EvaluationException("Error during sending messages");
            }
        } else {
            throw new EvaluationException("DF need to be a string or an array of strings");
        }
        return JamochaValue.FALSE;
    }

    private boolean checkServiceAndSend(JamochaValue sd, String df2, String sender, Engine engine) throws EvaluationException {
        if (sd.is(JamochaType.STRING)) {
            String service = sd.getStringValue();
            service = service.substring(1, service.length() - 1);
            ACLMessage message = this.makeMessage(engine, df2, sender, service);
            this.agent.send(message);
            String rule = "(defrule suche_message ?message <- (agent-message (conversation-id " + message.getConversationId() + ") ) => (agent-search ?message))";
            String delrule = "(undefrule suche_message)";
            this.channel = this.agent.getEngine().getMessageRouter().openChannel(this.agent.getProperties().getProperty("agent.name", "Agent"));
            this.channel.executeCommand(rule + "(fire)" + delrule);
            return true;
        }
        if (sd.is(JamochaType.LIST)) {
            String service = "";
            String helper = "";
            for (int i = 0; i < sd.getListCount(); ++i) {
                if (sd.getListValue(i).is(JamochaType.STRING)) {
                    service = sd.getListValue(i).getStringValue();
                    service = service.substring(1, service.length() - 1);
                    helper = helper + "\n" + service;
                    continue;
                }
                engine.writeMessage("Services need to be a string or an array of services which are strings");
            }
            if (helper != "") {
                ACLMessage message = this.makeMessage(engine, df2, sender, helper);
                this.agent.send(message);
                String rule = "(defrule suche_message ?message <- (agent-message (conversation-id " + message.getConversationId() + ") ) => (agent-search ?message))";
                String delrule = "(undefrule suche_message)";
                this.channel = this.agent.getEngine().getMessageRouter().openChannel(this.agent.getProperties().getProperty("agent.name", "Agent"));
                this.channel.executeCommand(rule);
                this.channel.executeCommand("(fire)");
                this.channel.executeCommand(delrule);
                return true;
            }
            throw new EvaluationException("Services error");
        }
        throw new EvaluationException("Services need to be a string or an array of services");
    }

    private ACLMessage makeMessage(Engine engine, String df, String sender, String sd) throws EvaluationException {
        String content;
        if (sd.contains("df-agent-description")) {
            content = "((action (agent-identifier :name " + df + ") " + "(search " + sd + ")))";
            content = content.replace("\n", " ");
        } else {
            content = "((action (agent-identifier :name " + df + ") " + "(search " + "(df-agent-description " + ":services " + "(set " + sd + "))" + "(search-constraints :minax-depth 2)" + ")))";
            content = content.replace("\n", " ");
        }
        ACLMessage message = new ACLMessage(16);
        if (sender.equals("")) {
            sender = this.agent.getName();
        }
        message.setSender(new AID(sender, true));
        message.addReceiver(new AID(df, true));
        message.addReplyTo(new AID(sender, true));
        message.setContent(content);
        message.setLanguage("fipa-sl0");
        message.setOntology("fipa-agent-management");
        message.setProtocol("fipa-request");
        Date dt = new Date();
        message.setConversationId("" + dt.getTime());
        return message;
    }

    private boolean checkanswer(Fact answer, Engine engine) throws EvaluationException {
        if (answer.getSlotValue("performative").toString().contains("inform")) {
            String newcontent = answer.getSlotValue("content").toString();
            if (newcontent.contains("sequence (")) {
                String returnsequence = newcontent.substring(newcontent.indexOf("sequence") + 9, newcontent.length() - 2);
                Integer first = newcontent.indexOf("name", newcontent.indexOf("sequence")) + 5;
                Integer second = newcontent.indexOf("services", newcontent.indexOf("sequence")) - 2;
                String returnname = newcontent.substring(first, second);
                String rule = "(bind ?factid (assert (agent-request-result (result \"" + returnname + "\")(message \"" + returnsequence + "\"))))";
                this.channel = this.agent.getEngine().getMessageRouter().openChannel(this.agent.getProperties().getProperty("agent.name", "Agent"));
                this.channel.executeCommand(rule);
                this.channel.executeCommand("(printout " + this.output + " \"Found and stored as factid \" ?factid)");
                return true;
            }
            engine.writeMessage("Nothing found", this.output);
            return false;
        }
        String newcontent = answer.getSlotValue("content").toString();
        if (newcontent.contains("missing-parameter service-description")) {
            engine.writeMessage("Sorry, missing-parameter service-description / wrong service-description.", this.output);
            return false;
        }
        if (newcontent.contains("unrecognised-value content")) {
            engine.writeMessage("Sorry, unrecognised-value content, please ceck your input.", this.output);
            return false;
        }
        engine.writeMessage("I got no inform message but an error code: " + answer.getSlotValue("performative").toString() + ". Please use the sniffer to identify the problem!", this.output);
        return false;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "This function search the DF for other agents";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            return "DF (as String or array of DFs), name of own agent, SD (as String or array of Strings)";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 1: {
                    return "DF";
                }
                case 2: {
                    return "AID";
                }
                case 3: {
                    return "SD";
                }
            }
            return "DF + AID + SD";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.FACTS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(bind ?ad '(df-agent-description :services (set (service-description :name profiling)))(search-constraints :minax-depth 2)') \n(agent-search ?df ?aid ?ad)\n Gives back something like that\"Found and stored as factid f-31\"";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

