/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.adaptor;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class JDBCLinkInit
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "jdbclink-init";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        Deftemplate jdbcConfigTemplate;
        TemplateSlot[] slots;
        String templateName = "jdbclink";
        if (engine.findModule("MAIN").getTemplate(templateName) == null) {
            slots = new TemplateSlot[]{new TemplateSlot("ConnectionName"), new TemplateSlot("TableName"), new TemplateSlot("TemplateName"), new TemplateSlot("Username"), new TemplateSlot("Password"), new TemplateSlot("JDBCurl"), new TemplateSlot("JDBCdriver")};
            for (int i = 0; i < slots.length; ++i) {
                slots[i].setValueType(JamochaType.STRING);
            }
            jdbcConfigTemplate = new Deftemplate(templateName, null, slots);
            engine.findModule("MAIN").addTemplate(jdbcConfigTemplate);
        }
        templateName = "jdbccondition";
        if (engine.findModule("MAIN").getTemplate(templateName) == null) {
            slots = new TemplateSlot[]{new TemplateSlot("SlotName"), new TemplateSlot("BooleanOperator"), new TemplateSlot("Value")};
            slots[0].setValueType(JamochaType.STRING);
            slots[1].setValueType(JamochaType.STRING);
            jdbcConfigTemplate = new Deftemplate(templateName, null, slots);
            engine.findModule("MAIN").addTemplate(jdbcConfigTemplate);
        }
        return JamochaValue.TRUE;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Initializes the JDBC adaptor by defining the jdbclink and jdbccondition template. Returns true on success.";
        }

        public int getParameterCount() {
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "";
        }

        public String getParameterName(int parameter) {
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate templ (slot a) (slot b) (slot c) (slot foo) )\n(jdbclink-init)\n(assert\n\t(jdbclink\n\t\t(JDBCdriver \"com.mysql.jdbc.Driver\")\n\t\t(ConnectionName \"db\")\n\t\t(TableName \"test\")\n\t\t(TemplateName \"templ\")\n\t\t(Username \"jamocha\")\n\t\t(Password \"secret\")\n\t\t(JDBCurl \"jdbc:mysql://134.130.113.67:3306/jamocha\")\n\t)\n)\n(assert\n\t(jdbccondition\n\t\t(SlotName \"foo\")\n\t\t(BooleanOperator \">\")\n\t\t(Value 2007-04-27 19:00+1)\n\t)\n)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

