/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.adaptor;

import java.util.HashMap;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.util.ExportHandler;
import org.jamocha.engine.util.ExportIterator;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class IteratorExporter
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "iteratorexporter";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 3) {
            Class<?> handlerclass = null;
            try {
                handlerclass = Class.forName(params[0].getValue(engine).getStringValue());
            }
            catch (ClassNotFoundException e1) {
                return JamochaValue.newLong(-1L);
            }
            Fact configFact = engine.getFactById(params[1].getValue(engine).getFactIdValue());
            Template configtemplate = configFact.getTemplate();
            TemplateSlot[] keys = configtemplate.getAllSlots();
            HashMap<String, String> configMap = new HashMap<String, String>();
            for (TemplateSlot key : keys) {
                configMap.put(key.getName(), configFact.getSlotValue(key.getName()).getStringValue());
            }
            ExportHandler handler = null;
            try {
                handler = (ExportHandler)handlerclass.newInstance();
            }
            catch (Exception e1) {
                return JamochaValue.newLong(-1L);
            }
            JamochaValue forExport = params[2].getValue(engine);
            long[] facts = new long[forExport.getListCount()];
            for (int i = 0; i < forExport.getListCount(); ++i) {
                facts[i] = forExport.getListValue(i).getFactIdValue();
            }
            ExportIterator iterator = new ExportIterator(engine, facts);
            long result = handler.export(iterator, configMap);
            return JamochaValue.newLong(result);
        }
        throw new IllegalParameterException(3, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Exports facts from the rete engine to an external location. The external location is specified in the first argument and needs to be an user-implementation of a subclass of org.jamocha.rete.util.ExportHandler. The function first generates a mapping from the config-fact given in the second argument. After that it exports all facts from the fact-list given as third argument via the iterator.";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "External location, class name of a subclass of org.jamocha.rete.util.ExportHandler.";
                }
                case 1: {
                    return "Config-fact, to generate the mapping for the export from.";
                }
                case 2: {
                    return "Fact-list to export via the iterator.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "ExportHandlerClass";
                }
                case 1: {
                    return "ConfigFact";
                }
                case 2: {
                    return "FactsToExport";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.STRINGS;
                }
                case 1: {
                    return JamochaType.FACT_IDS;
                }
                case 2: {
                    return JamochaType.LISTS;
                }
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LONGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate a \t(slot horst))\n(deftemplate b\t(slot heiner))\n(deftemplate c\t(slot ory))\n(deftemplate d\t(slot krautsalat))\n(bind ?horst (assert (a (horst 1))))\n(bind ?heiner1 (assert\t(b (heiner 13))))\n(bind ?heiner2\t(assert\t(b (heiner 1))))\n(bind ?ory\t(assert\t(c (ory 4711))))\n(bind ?krautsalat (assert (d (krautsalat 11))))\n(deftemplate config (slot removeSlot))\n(bind ?config (assert (config (removeSlot \"heiner\"))))\n(iteratorexporter \"org.jamocha.sampleimplementations.SampleExportHandler\"  ?config (create$ ?horst ?heiner1 ?ory ?krautsalat))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

