/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Return
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "return";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.NIL;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof Expression)) {
                    throw new EvaluationException("Parameter " + i + " is no Expression.");
                }
                result = params[i].getValue(engine);
            }
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Return just returns the result of an Expression or the last result of a whole ExpressionSequence.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Some Expression or List of Expressions whose result should be returned.";
        }

        public String getParameterName(int parameter) {
            return "expression";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.ANY;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return true;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

