/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions;

import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.LoopForCountConfiguration;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class LoopForCount
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "loop-for-count";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.NIL;
        if (params != null && params.length == 1) {
            engine.pushScope();
            LoopForCountConfiguration lfcConf = (LoopForCountConfiguration)params[0];
            BoundParam countVar = lfcConf.getLoopVar();
            JamochaValue startValue = lfcConf.getStartIndex().getValue(engine);
            if (!startValue.is(JamochaType.LONG)) {
                throw new IllegalTypeException(JamochaType.LONGS, startValue.getType());
            }
            JamochaValue endValue = lfcConf.getEndIndex().getValue(engine);
            if (!endValue.is(JamochaType.LONG)) {
                throw new IllegalTypeException(JamochaType.LONGS, startValue.getType());
            }
            long endIndex = endValue.getLongValue();
            for (long i = startValue.getLongValue(); i <= endIndex; ++i) {
                engine.setBinding(countVar.getVariableName(), JamochaValue.newLong(i));
                result = lfcConf.getActions().getValue(engine);
            }
        } else {
            throw new IllegalParameterException(1);
        }
        engine.popScope();
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "loop-for-count counts up a given variable from a start index to an end index and executes a list of given actions. Returns the result of the last action executed.";
        }

        public int getParameterCount() {
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "";
        }

        public String getParameterName(int parameter) {
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.ANY;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

