/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.configurations;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.AbstractConfiguration;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;

public class SlotConfiguration
extends AbstractConfiguration {
    private String slotName = null;
    private int id;
    private Parameter[] slotValues = null;

    public boolean isFactBinding() {
        return false;
    }

    public SlotConfiguration clone() {
        SlotConfiguration sc = new SlotConfiguration(this.slotName, this.id, (Parameter[])this.slotValues.clone());
        return sc;
    }

    public String getExpressionString() {
        return null;
    }

    public JamochaValue getValue(Engine engine) throws EvaluationException {
        if (this.isMultislot().booleanValue()) {
            JamochaValue[] jvs = new JamochaValue[this.slotValues.length];
            for (int i = 0; i < this.slotValues.length; ++i) {
                jvs[i] = this.slotValues[i].getValue(engine);
            }
            return JamochaValue.newList(jvs);
        }
        if (this.slotValues.length > 0) {
            return this.slotValues[0].getValue(engine);
        }
        return JamochaValue.NIL;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Parameter[] getSlotValues() {
        return this.slotValues;
    }

    public void setSlotValues(Parameter[] slotValues) {
        this.slotValues = slotValues;
    }

    public Boolean isMultislot() {
        Boolean result = this.slotValues.length > 1;
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    public SlotConfiguration(String slotName, int id, Parameter[] slotValues) {
        this.slotName = slotName;
        this.id = id;
        this.slotValues = slotValues;
    }

    public SlotConfiguration() {
    }
}

