/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.agenda;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jamocha.engine.agenda.Activation;
import org.jamocha.engine.agenda.BreadthStrategy;
import org.jamocha.engine.agenda.DepthStrategy;
import org.jamocha.engine.agenda.HighestComplexityFirstStrategy;
import org.jamocha.engine.agenda.HighestPriorityFirstStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConflictResolutionStrategy
implements Comparator<Activation> {
    private static boolean initialized;
    private static Map<String, Class> map;

    public abstract String getName();

    public static String getNameStatic() {
        return "abstract-strategy";
    }

    private static void registerStrategy(Class strategy) {
        try {
            String stratName = (String)strategy.getMethod("getNameStatic", new Class[0]).invoke(ConflictResolutionStrategy.class, (Object[])new Class[0]);
            map.put(stratName, strategy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void init() {
        if (initialized) {
            return;
        }
        map = new HashMap<String, Class>();
        ConflictResolutionStrategy.registerStrategy(DepthStrategy.class);
        ConflictResolutionStrategy.registerStrategy(BreadthStrategy.class);
        ConflictResolutionStrategy.registerStrategy(HighestPriorityFirstStrategy.class);
        ConflictResolutionStrategy.registerStrategy(HighestComplexityFirstStrategy.class);
        initialized = true;
    }

    public static ConflictResolutionStrategy getStrategy(String strategy) throws InstantiationException, IllegalAccessException {
        ConflictResolutionStrategy.init();
        Class stratCls = map.get(strategy);
        if (stratCls == null) {
            return null;
        }
        return (ConflictResolutionStrategy)stratCls.newInstance();
    }

    public static Set<String> getStrategies() {
        ConflictResolutionStrategy.init();
        return map.keySet();
    }
}

