/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.agenda;

import org.jamocha.engine.Engine;
import org.jamocha.engine.ExecuteException;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.nodes.TerminalNode;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.rules.Action;
import org.jamocha.rules.Rule;

public class Activation {
    protected Rule rule;
    protected boolean valid = true;
    protected FactTuple tuple;
    protected long aggregatedTime = 0L;
    protected TerminalNode tnode;

    public int hashCode() {
        return this.rule.hashCode() + this.tuple.hashCode() + this.tnode.getId();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Activation) {
            Activation other = (Activation)obj;
            return this.tuple.equals(other.tuple) && this.rule.equals(other.rule) && this.tnode == other.tnode;
        }
        return false;
    }

    public Activation(Rule rule, FactTuple tuple, TerminalNode tnode) {
        this.rule = rule;
        this.tnode = tnode;
        this.setTuple(tuple);
    }

    public Rule getRule() {
        return this.rule;
    }

    public FactTuple getTuple() {
        return this.tuple;
    }

    protected void setTuple(FactTuple tuple) {
        this.tuple = tuple;
        for (Fact fact : tuple) {
            this.aggregatedTime = Math.max(this.aggregatedTime, fact.getCreationTimeStamp());
        }
    }

    public void fire(Engine engine) throws ExecuteException {
        engine.pushScope(this.rule);
        for (Action action : this.rule.getActions()) {
            action.executeAction(this.tuple, this.tnode);
        }
        engine.popScope();
    }

    public String toString() {
        return "[" + this.rule.toString() + " " + this.tuple.toString() + "]";
    }
}

