/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import java.beans.ExceptionListener;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jamocha.engine.Engine;
import org.jamocha.engine.TemporalValidity;

public abstract class TemporalThread
extends Thread {
    protected Engine engine;
    protected Queue<TemporalValidity.EventPoint> eventPoints;
    protected ExceptionListener exceptionListener;
    protected int threadLag;

    public TemporalThread(Engine e, String name) {
        this.engine = e;
        this.setName(name);
        this.eventPoints = new PriorityQueue<TemporalValidity.EventPoint>(100, new EventPointComparator());
        this.exceptionListener = null;
    }

    public void registerExceptionListener(ExceptionListener l) {
        this.exceptionListener = l;
    }

    protected static long now() {
        return System.currentTimeMillis();
    }

    public int getLag() {
        return this.threadLag < 0 ? 0 : this.threadLag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            TemporalThread temporalThread = this;
            synchronized (temporalThread) {
                TemporalValidity.EventPoint nextEventPoint = this.eventPoints.peek();
                if (nextEventPoint == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                } else {
                    long to = nextEventPoint.getTimestamp();
                    long from = TemporalThread.now();
                    long distance = to - from;
                    try {
                        if (distance > 0L) {
                            this.wait(distance);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    long d = to - TemporalThread.now();
                    this.threadLag = -((int)d);
                    if (d <= 0L) {
                        nextEventPoint = this.eventPoints.peek();
                        while (nextEventPoint.getTimestamp() == to) {
                            this.eventPoints.remove();
                            this.handle(nextEventPoint);
                            this.skipToNextEventPoint(nextEventPoint);
                            nextEventPoint = this.eventPoints.peek();
                            if (nextEventPoint != null) continue;
                        }
                        if (this.eventPoints.isEmpty()) {
                            this.threadLag = 0;
                        }
                    }
                }
            }
        }
    }

    protected abstract void skipToNextEventPoint(TemporalValidity.EventPoint var1);

    protected abstract void handle(TemporalValidity.EventPoint var1);

    protected void notifyForException(Exception e) {
        if (this.exceptionListener != null) {
            this.exceptionListener.exceptionThrown(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EventPointComparator
    implements Comparator<TemporalValidity.EventPoint> {
        protected EventPointComparator() {
        }

        @Override
        public int compare(TemporalValidity.EventPoint o1, TemporalValidity.EventPoint o2) {
            long l = o1.getTimestamp() - o2.getTimestamp();
            if (l == 0L) {
                return 0;
            }
            if (l < 0L) {
                return -1;
            }
            return 1;
        }
    }
}

