/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import java.util.Arrays;
import java.util.GregorianCalendar;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.TemporalValidity;

public class GregorianTemporalValidity
implements TemporalValidity {
    public final long MAXIMUM_FORWARD_WINDOW = 2592000000L;
    public final long WINDOW_EXCEEDED = 0x3FFFFFFFFFFFFFFFL;
    private IntervalLayer[] intervalLayers = new IntervalLayer[8];
    private long duration;

    private IntervalLayer expand(String cronStyle, int dBegin, int dEnd, int type) throws NumberFormatException {
        if (cronStyle.length() == 0) {
            cronStyle = "*";
        }
        if (cronStyle.startsWith("*")) {
            int stepSize = cronStyle.equals("*") ? 1 : Integer.parseInt(cronStyle.substring(2));
            int cnt = (dEnd - dBegin + 1) / stepSize;
            if ((dEnd - dBegin + 1) % stepSize != 0) {
                ++cnt;
            }
            int[] result = new int[cnt];
            int j = 0;
            for (int i = dBegin; i <= dEnd; i += stepSize) {
                result[j++] = i;
            }
            return new IntervalLayer(type, result);
        }
        String[] values = cronStyle.split(",");
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
            if (result[i] >= dBegin && result[i] <= dEnd) continue;
            throw new NumberFormatException();
        }
        return new IntervalLayer(type, result);
    }

    public GregorianTemporalValidity() {
        this.setMilliseconds("*");
        this.setSeconds("*");
        this.setMinutes("*");
        this.setHours("*");
        this.setWeekdays("*");
        this.setDays("*");
        this.setMonths("*");
        this.setYears("*");
        this.duration = 1000L;
    }

    public void setMilliseconds(String msec) {
        this.intervalLayers[7] = this.expand(msec, 0, 999, 14);
    }

    public void setSeconds(String sec) {
        this.intervalLayers[6] = this.expand(sec, 0, 59, 13);
    }

    public void setMinutes(String min) {
        this.intervalLayers[5] = this.expand(min, 0, 59, 12);
    }

    public void setHours(String hour) {
        this.intervalLayers[4] = this.expand(hour, 0, 23, 11);
    }

    public void setWeekdays(String weekday) {
        this.intervalLayers[3] = this.expand(weekday, 0, 6, 7);
    }

    public void setDays(String day) {
        this.intervalLayers[2] = this.expand(day, 1, 31, 5);
    }

    public void setMonths(String month) {
        this.intervalLayers[1] = this.expand(month, 1, 12, 2);
    }

    public void setYears(String year) {
        this.intervalLayers[0] = this.expand(year, 1980, 3000, 1);
    }

    public void setDuration(String duration) {
        String unit = duration.substring(duration.length() - 1);
        String val = duration.substring(0, duration.length() - 1);
        int v = unit.equals("s") ? 1000 * Integer.parseInt(val) : (unit.equals("m") ? 60000 * Integer.parseInt(val) : (unit.equals("h") ? 3600000 * Integer.parseInt(val) : (unit.equals("d") ? 86400000 * Integer.parseInt(val) : Integer.parseInt(duration))));
        this.duration = v;
    }

    private long getNextEventHelper(long from, long forward_distance) {
        if (forward_distance > 2592000000L) {
            return 0x3FFFFFFFFFFFFFFFL;
        }
        long t = from;
        for (int i = 0; i < this.intervalLayers.length; ++i) {
            IntervalLayer layer = this.intervalLayers[i];
            if (layer.isActivated(t)) continue;
            t = layer.nextActivatedFrom(t);
            for (int j = i + 1; j < this.intervalLayers.length; ++j) {
                t = this.intervalLayers[j].setToBegin(t);
            }
        }
        boolean isIn = true;
        for (IntervalLayer layer : this.intervalLayers) {
            isIn = isIn && layer.isActivated(t);
        }
        if (isIn) {
            return t;
        }
        return this.getNextEventHelper(t, t - from);
    }

    public TemporalValidity.EventPoint getNextEvent(long from) {
        long r1 = this.getNextEventHelper(from, 0L);
        long r2 = this.getNextEventHelper(from - this.duration, 0L) + this.duration;
        if (r1 == 0x3FFFFFFFFFFFFFFFL && r2 == 0x3FFFFFFFFFFFFFFFL) {
            Logging.logger(this.getClass()).debug("Forward window exceeded");
            return new TemporalValidity.EventPoint(TemporalValidity.EventPoint.Type.WINDOW_EXCEEDED, 2592000000L);
        }
        TemporalValidity.EventPoint result = r1 < r2 ? new TemporalValidity.EventPoint(TemporalValidity.EventPoint.Type.START, r1) : new TemporalValidity.EventPoint(TemporalValidity.EventPoint.Type.STOP, r2);
        return result;
    }

    class IntervalLayer {
        private int field;
        private int[] beginPoints;

        public IntervalLayer(int field, int[] beginPoints) {
            this.field = field;
            this.beginPoints = beginPoints;
        }

        private int getFromField(GregorianCalendar g, int field) {
            int result = g.get(field);
            if (field == 2) {
                ++result;
            }
            if (field == 7) {
                if (result == 2) {
                    return 0;
                }
                if (result == 3) {
                    return 1;
                }
                if (result == 4) {
                    return 2;
                }
                if (result == 5) {
                    return 3;
                }
                if (result == 6) {
                    return 4;
                }
                if (result == 7) {
                    return 5;
                }
                if (result == 1) {
                    return 6;
                }
            }
            return result;
        }

        public boolean isActivated(long timestamp) {
            GregorianCalendar b = new GregorianCalendar();
            b.setTimeInMillis(timestamp);
            int f = this.getFromField(b, this.field);
            return Arrays.binarySearch(this.beginPoints, f) >= 0;
        }

        public long nextActivatedFrom(long timestamp) {
            GregorianCalendar b = new GregorianCalendar();
            b.setTimeInMillis(timestamp);
            int f = this.getFromField(b, this.field);
            int idx = 0;
            while (this.beginPoints[idx] < f) {
                if (++idx != this.beginPoints.length) continue;
                idx = 0;
                break;
            }
            int newFieldval = this.beginPoints[idx];
            while (f != newFieldval) {
                b.add(this.field, 1);
                f = this.getFromField(b, this.field);
            }
            return b.getTimeInMillis();
        }

        public long setToBegin(long time) {
            GregorianCalendar t = new GregorianCalendar();
            t.setTimeInMillis(time);
            switch (this.field) {
                case 2: {
                    t.set(2, 0);
                }
                case 5: {
                    t.set(5, 1);
                }
                case 11: {
                    t.set(11, 0);
                }
                case 12: {
                    t.set(12, 0);
                }
                case 13: {
                    t.set(13, 0);
                }
                case 14: {
                    t.set(14, 0);
                }
            }
            return t.getTimeInMillis();
        }
    }
}

