/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import java.math.BigDecimal;
import org.jamocha.parser.JamochaValue;

public class Evaluate {
    public static boolean evaluate(int operator, JamochaValue left, JamochaValue right) {
        boolean eval = false;
        switch (operator) {
            case 9: {
                return left.equals(right);
            }
            case 10: {
                return !left.equals(right);
            }
            case 6: {
                eval = Evaluate.evaluateLess(left.getObjectValue(), right.getObjectValue());
                break;
            }
            case 8: {
                eval = Evaluate.evaluateLessEqual(left.getObjectValue(), right.getObjectValue());
                break;
            }
            case 5: {
                eval = Evaluate.evaluateGreater(left.getObjectValue(), right.getObjectValue());
                break;
            }
            case 7: {
                eval = Evaluate.evaluateGreaterEqual(left.getObjectValue(), right.getObjectValue());
                break;
            }
            case 11: {
                eval = Evaluate.evaluateNull(left.getObjectValue(), right.getObjectValue());
            }
        }
        return eval;
    }

    public static boolean evaluateStringEqual(String left, Object right) {
        if (right instanceof Boolean) {
            return left.equals(right.toString());
        }
        return left.equals(right);
    }

    public static boolean evaluateLess(Object left, Object right) {
        if (left instanceof Integer) {
            return Evaluate.evaluateLess((Integer)left, right);
        }
        if (left instanceof Short) {
            return Evaluate.evaluateLess((Short)left, right);
        }
        if (left instanceof Long) {
            return Evaluate.evaluateLess((Long)left, right);
        }
        if (left instanceof Float) {
            return Evaluate.evaluateLess((Float)left, right);
        }
        if (left instanceof Double) {
            return Evaluate.evaluateLess((Double)left, right);
        }
        if (left instanceof BigDecimal) {
            return Evaluate.evaluateLess((BigDecimal)left, right);
        }
        return false;
    }

    public static boolean evaluateLessEqual(Object left, Object right) {
        if (left instanceof Integer) {
            return Evaluate.evaluateLessEqual((Integer)left, right);
        }
        if (left instanceof Short) {
            return Evaluate.evaluateLessEqual((Short)left, right);
        }
        if (left instanceof Long) {
            return Evaluate.evaluateLessEqual((Long)left, right);
        }
        if (left instanceof Float) {
            return Evaluate.evaluateLessEqual((Float)left, right);
        }
        if (left instanceof Double) {
            return Evaluate.evaluateLessEqual((Double)left, right);
        }
        if (left instanceof BigDecimal) {
            return Evaluate.evaluateLessEqual((BigDecimal)left, right);
        }
        return false;
    }

    public static boolean evaluateGreater(Object left, Object right) {
        if (left instanceof Integer) {
            return Evaluate.evaluateGreater(left, right);
        }
        if (left instanceof Short) {
            return Evaluate.evaluateGreater((Short)left, right);
        }
        if (left instanceof Long) {
            return Evaluate.evaluateGreater((Long)left, right);
        }
        if (left instanceof Float) {
            return Evaluate.evaluateGreater((Float)left, right);
        }
        if (left instanceof Double) {
            return Evaluate.evaluateGreater((Double)left, right);
        }
        if (left instanceof BigDecimal) {
            return Evaluate.evaluateGreater((BigDecimal)left, right);
        }
        return false;
    }

    public static boolean evaluateGreaterEqual(Object left, Object right) {
        if (left instanceof Integer) {
            return Evaluate.evaluateGreaterEqual((Integer)left, right);
        }
        if (left instanceof Short) {
            return Evaluate.evaluateGreaterEqual((Short)left, right);
        }
        if (left instanceof Long) {
            return Evaluate.evaluateGreaterEqual((Long)left, right);
        }
        if (left instanceof Float) {
            return Evaluate.evaluateGreaterEqual((Float)left, right);
        }
        if (left instanceof Double) {
            return Evaluate.evaluateGreaterEqual((Double)left, right);
        }
        if (left instanceof BigDecimal) {
            return Evaluate.evaluateGreaterEqual(left, right);
        }
        return false;
    }

    public static boolean evaluateNull(Object left, Object right) {
        return right == null;
    }

    public static boolean evaluateLess(Integer left, Object right) {
        if (right instanceof Integer) {
            return left < (Integer)right;
        }
        if (right instanceof Short) {
            return left < ((Short)right).intValue();
        }
        if (right instanceof Long) {
            return left.longValue() < (Long)right;
        }
        if (right instanceof Float) {
            return left.floatValue() < ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() < (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() < ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLessEqual(Integer left, Object right) {
        if (right instanceof Integer) {
            return left <= (Integer)right;
        }
        if (right instanceof Short) {
            return left <= ((Short)right).intValue();
        }
        if (right instanceof Long) {
            return left.longValue() <= (Long)right;
        }
        if (right instanceof Float) {
            return left.floatValue() <= ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() <= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() <= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreater(Integer left, Number right) {
        if (right instanceof Integer) {
            return left > (Integer)right;
        }
        if (right instanceof Short) {
            return left > ((Short)right).intValue();
        }
        if (right instanceof Long) {
            return left.longValue() > (Long)right;
        }
        if (right instanceof Float) {
            return left.floatValue() > ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() > (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() > ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreaterEqual(Integer left, Object right) {
        if (right instanceof Integer) {
            return left >= (Integer)right;
        }
        if (right instanceof Short) {
            return left >= ((Short)right).intValue();
        }
        if (right instanceof Long) {
            return left.longValue() >= (Long)right;
        }
        if (right instanceof Float) {
            return left.floatValue() >= ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() >= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() >= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLess(Short left, Object right) {
        if (right instanceof Short) {
            return left < (Short)right;
        }
        if (right instanceof Integer) {
            return left.intValue() < (Integer)right;
        }
        if (right instanceof Float) {
            return left.floatValue() < ((Float)right).floatValue();
        }
        if (right instanceof Long) {
            return left.longValue() < (Long)right;
        }
        if (right instanceof Double) {
            return left.doubleValue() < (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() < ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLessEqual(Short left, Object right) {
        if (right instanceof Short) {
            return left <= (Short)right;
        }
        if (right instanceof Integer) {
            return left.intValue() <= (Integer)right;
        }
        if (right instanceof Float) {
            return left.floatValue() <= ((Float)right).floatValue();
        }
        if (right instanceof Long) {
            return left.longValue() <= (Long)right;
        }
        if (right instanceof Double) {
            return left.doubleValue() <= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() <= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreater(Short left, Object right) {
        if (right instanceof Short) {
            return left > (Short)right;
        }
        if (right instanceof Integer) {
            return left.intValue() > (Integer)right;
        }
        if (right instanceof Float) {
            return left.floatValue() > ((Float)right).floatValue();
        }
        if (right instanceof Long) {
            return left.longValue() > (Long)right;
        }
        if (right instanceof Double) {
            return left.doubleValue() > (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() > ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreaterEqual(Short left, Object right) {
        if (right instanceof Short) {
            return left >= (Short)right;
        }
        if (right instanceof Integer) {
            return left.intValue() >= (Integer)right;
        }
        if (right instanceof Float) {
            return left.floatValue() >= ((Float)right).floatValue();
        }
        if (right instanceof Long) {
            return left.longValue() >= (Long)right;
        }
        if (right instanceof Double) {
            return left.doubleValue() >= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() >= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLess(Long left, Object right) {
        if (right instanceof Long) {
            return left < (Long)right;
        }
        if (right instanceof Integer) {
            return left < ((Integer)right).longValue();
        }
        if (right instanceof Short) {
            return left < ((Short)right).longValue();
        }
        if (right instanceof Float) {
            return left.floatValue() < ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() < (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() < ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLessEqual(Long left, Object right) {
        if (right instanceof Long) {
            return left <= (Long)right;
        }
        if (right instanceof Integer) {
            return left <= ((Integer)right).longValue();
        }
        if (right instanceof Short) {
            return left <= ((Short)right).longValue();
        }
        if (right instanceof Float) {
            return left.floatValue() <= ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() <= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() <= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreater(Long left, Object right) {
        if (right instanceof Long) {
            return left > (Long)right;
        }
        if (right instanceof Integer) {
            return left > ((Integer)right).longValue();
        }
        if (right instanceof Short) {
            return left > ((Short)right).longValue();
        }
        if (right instanceof Float) {
            return left.floatValue() > ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() > (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() > ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreaterEqual(Long left, Object right) {
        if (right instanceof Long) {
            return left >= (Long)right;
        }
        if (right instanceof Integer) {
            return left >= ((Integer)right).longValue();
        }
        if (right instanceof Short) {
            return left >= ((Short)right).longValue();
        }
        if (right instanceof Float) {
            return left.floatValue() >= ((Float)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() >= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() >= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLess(Float left, Object right) {
        if (right instanceof Float) {
            return left.floatValue() < ((Float)right).floatValue();
        }
        if (right instanceof Integer) {
            return left.floatValue() < ((Integer)right).floatValue();
        }
        if (right instanceof Short) {
            return left.floatValue() < ((Short)right).floatValue();
        }
        if (right instanceof Long) {
            return left.floatValue() < ((Long)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() < (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() < ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLessEqual(Float left, Object right) {
        if (right instanceof Float) {
            return left.floatValue() <= ((Float)right).floatValue();
        }
        if (right instanceof Integer) {
            return left.floatValue() <= ((Integer)right).floatValue();
        }
        if (right instanceof Short) {
            return left.floatValue() <= ((Short)right).floatValue();
        }
        if (right instanceof Long) {
            return left.floatValue() <= ((Long)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() <= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() <= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreater(Float left, Object right) {
        if (right instanceof Float) {
            return left.floatValue() > ((Float)right).floatValue();
        }
        if (right instanceof Integer) {
            return left.floatValue() > ((Integer)right).floatValue();
        }
        if (right instanceof Short) {
            return left.floatValue() > ((Short)right).floatValue();
        }
        if (right instanceof Long) {
            return left.floatValue() > ((Long)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() > (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() > ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreaterEqual(Float left, Object right) {
        if (right instanceof Float) {
            return left.floatValue() >= ((Float)right).floatValue();
        }
        if (right instanceof Integer) {
            return left.floatValue() >= ((Integer)right).floatValue();
        }
        if (right instanceof Short) {
            return left.floatValue() >= ((Short)right).floatValue();
        }
        if (right instanceof Long) {
            return left.floatValue() >= ((Long)right).floatValue();
        }
        if (right instanceof Double) {
            return left.doubleValue() >= (Double)right;
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() >= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLess(Double left, Object right) {
        if (right instanceof Double) {
            return left < (Double)right;
        }
        if (right instanceof Integer) {
            return left < ((Integer)right).doubleValue();
        }
        if (right instanceof Short) {
            return left < ((Short)right).doubleValue();
        }
        if (right instanceof Float) {
            return left < ((Float)right).doubleValue();
        }
        if (right instanceof Long) {
            return left < ((Long)right).doubleValue();
        }
        if (right instanceof BigDecimal) {
            return left <= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLess(BigDecimal left, Object right) {
        if (right instanceof Double) {
            return left.doubleValue() < (Double)right;
        }
        if (right instanceof Integer) {
            return left.doubleValue() < ((Integer)right).doubleValue();
        }
        if (right instanceof Short) {
            return left.doubleValue() < ((Short)right).doubleValue();
        }
        if (right instanceof Float) {
            return left.doubleValue() < ((Float)right).doubleValue();
        }
        if (right instanceof Long) {
            return left.doubleValue() < ((Long)right).doubleValue();
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() < ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLessEqual(Double left, Object right) {
        if (right instanceof Double) {
            return left <= (Double)right;
        }
        if (right instanceof Integer) {
            return left <= ((Integer)right).doubleValue();
        }
        if (right instanceof Short) {
            return left <= ((Short)right).doubleValue();
        }
        if (right instanceof Float) {
            return left <= ((Float)right).doubleValue();
        }
        if (right instanceof Long) {
            return left <= ((Long)right).doubleValue();
        }
        if (right instanceof BigDecimal) {
            return left <= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateLessEqual(BigDecimal left, Object right) {
        if (right instanceof Double) {
            return left.doubleValue() <= (Double)right;
        }
        if (right instanceof Integer) {
            return left.doubleValue() <= ((Integer)right).doubleValue();
        }
        if (right instanceof Short) {
            return left.doubleValue() <= ((Short)right).doubleValue();
        }
        if (right instanceof Float) {
            return left.doubleValue() <= ((Float)right).doubleValue();
        }
        if (right instanceof Long) {
            return left.doubleValue() <= ((Long)right).doubleValue();
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() <= ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreater(BigDecimal left, Object right) {
        if (right instanceof Double) {
            return left.doubleValue() > (Double)right;
        }
        if (right instanceof Integer) {
            return left.doubleValue() > ((Integer)right).doubleValue();
        }
        if (right instanceof Short) {
            return left.doubleValue() > ((Short)right).doubleValue();
        }
        if (right instanceof Float) {
            return left.doubleValue() > ((Float)right).doubleValue();
        }
        if (right instanceof Long) {
            return left.doubleValue() > ((Long)right).doubleValue();
        }
        if (right instanceof BigDecimal) {
            return left.doubleValue() > ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreater(Double left, Object right) {
        if (right instanceof Double) {
            return left > (Double)right;
        }
        if (right instanceof Integer) {
            return left > ((Integer)right).doubleValue();
        }
        if (right instanceof Short) {
            return left > ((Short)right).doubleValue();
        }
        if (right instanceof Float) {
            return left > ((Float)right).doubleValue();
        }
        if (right instanceof Long) {
            return left > ((Long)right).doubleValue();
        }
        if (right instanceof BigDecimal) {
            return left > ((BigDecimal)right).doubleValue();
        }
        return false;
    }

    public static boolean evaluateGreaterEqual(Double left, Object right) {
        if (right instanceof Double) {
            return left >= (Double)right;
        }
        if (right instanceof Integer) {
            return left >= ((Integer)right).doubleValue();
        }
        if (right instanceof Short) {
            return left >= ((Short)right).doubleValue();
        }
        if (right instanceof Float) {
            return left >= ((Float)right).doubleValue();
        }
        if (right instanceof Long) {
            return left >= ((Long)right).doubleValue();
        }
        if (right instanceof BigDecimal) {
            return left >= ((BigDecimal)right).doubleValue();
        }
        return false;
    }
}

