/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import java.util.HashMap;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionUtils {
    private static HashMap<Integer, String> OPR_MAP = new HashMap();
    private static HashMap<String, String> STROPR_MAP;

    public static String getOperatorDescription(int opr) {
        return OPR_MAP.get(opr);
    }

    public static String getOperator(int opr) {
        return STROPR_MAP.get(OPR_MAP.get(opr));
    }

    public static Fact findFact(Template temp, Fact[] facts) {
        Fact ft = null;
        for (int idx = 0; idx < facts.length; ++idx) {
            if (facts[idx].getTemplate() != temp) continue;
            ft = facts[idx];
        }
        return ft;
    }

    public static Fact[] mergeFacts(Fact[] left, Fact[] right) {
        Fact[] merged = new Fact[left.length + right.length];
        System.arraycopy(left, 0, merged, 0, left.length);
        System.arraycopy(right, 0, merged, left.length, right.length);
        return merged;
    }

    public static Fact[] mergeFacts(Fact[] left, Fact right) {
        Fact[] merged = new Fact[left.length + 1];
        for (int idx = 0; idx < left.length; ++idx) {
            merged[idx] = left[idx];
        }
        merged[left.length] = right;
        return merged;
    }

    public static Node[] add(Node[] list, Node nobj) {
        Node[] newlist = new Node[list.length + 1];
        System.arraycopy(list, 0, newlist, 0, list.length);
        newlist[list.length] = nobj;
        return newlist;
    }

    public static Node[] remove(Node[] list, Node nobj) {
        Node[] newlist = new Node[list.length - 1];
        int pos = 0;
        for (int idx = 0; idx < list.length; ++idx) {
            if (list[idx] == nobj) continue;
            newlist[pos] = list[idx];
            ++pos;
        }
        return newlist;
    }

    public static int getTypeCode(Class<?> clzz) {
        if (clzz.isArray()) {
            return 10;
        }
        if (clzz.isPrimitive()) {
            if (clzz == Integer.TYPE) {
                return 1;
            }
            if (clzz == Short.TYPE) {
                return 2;
            }
            if (clzz == Long.TYPE) {
                return 3;
            }
            if (clzz == Float.TYPE) {
                return 4;
            }
            if (clzz == Byte.TYPE) {
                return 6;
            }
            if (clzz == Double.TYPE) {
                return 5;
            }
            if (clzz == Boolean.TYPE) {
                return 7;
            }
            if (clzz == Character.TYPE) {
                return 8;
            }
            return 9;
        }
        if (clzz == String.class) {
            return 11;
        }
        return 9;
    }

    public static String getTypeName(int intType) {
        if (intType == 1) {
            return "INTEGER";
        }
        if (intType == 2) {
            return "SHORT";
        }
        if (intType == 3) {
            return "LONG";
        }
        if (intType == 4) {
            return "FLOAT";
        }
        if (intType == 5) {
            return "DOUBLE";
        }
        if (intType == 6) {
            return "BYTE";
        }
        if (intType == 7) {
            return "BOOLEAN";
        }
        if (intType == 8) {
            return "CHAR";
        }
        if (intType == 11) {
            return "STRING";
        }
        if (intType == 10) {
            return Object[].class.getName();
        }
        return Object.class.getName();
    }

    public static int getOperatorCode(String strSymbol) {
        if (strSymbol.equals("=")) {
            return 9;
        }
        if (strSymbol.equals("!=")) {
            return 10;
        }
        if (strSymbol.equals("+")) {
            return 1;
        }
        if (strSymbol.equals("-")) {
            return 2;
        }
        if (strSymbol.equals("*")) {
            return 3;
        }
        if (strSymbol.equals("/")) {
            return 4;
        }
        if (strSymbol.equals(">")) {
            return 5;
        }
        if (strSymbol.equals(">=")) {
            return 7;
        }
        if (strSymbol.equals("<")) {
            return 6;
        }
        if (strSymbol.equals("<=")) {
            return 8;
        }
        return 9;
    }

    public static int getOppositeOperatorCode(int op) {
        int rvop = 9;
        switch (op) {
            case 9: {
                rvop = 10;
                break;
            }
            case 10: {
                rvop = 9;
                break;
            }
            case 5: {
                rvop = 6;
                break;
            }
            case 6: {
                rvop = 5;
                break;
            }
            case 7: {
                rvop = 8;
                break;
            }
            case 8: {
                rvop = 7;
            }
        }
        return rvop;
    }

    public static boolean isPredicateOperatorCode(String strSymbol) {
        if (strSymbol.equals("=")) {
            return true;
        }
        if (strSymbol.equals("!=")) {
            return true;
        }
        if (strSymbol.equals(">")) {
            return true;
        }
        if (strSymbol.equals(">=")) {
            return true;
        }
        if (strSymbol.equals("<")) {
            return true;
        }
        return strSymbol.equals("<=");
    }

    public static String formatSlot(Object s) {
        if (s != null) {
            if (s instanceof Boolean) {
                return s.toString().toUpperCase();
            }
            if (s instanceof String) {
                return "\"" + s.toString() + "\"";
            }
            if (s.getClass() != null && s.getClass().isArray()) {
                StringBuffer buf = new StringBuffer();
                Object[] ary = (Object[])s;
                for (int idx = 0; idx < ary.length; ++idx) {
                    if (idx > 0) {
                        buf.append(" ");
                    }
                    buf.append(ConversionUtils.formatSlot(ary[idx]));
                }
                return buf.toString();
            }
            return s.toString();
        }
        return "nil";
    }

    public static void main(String[] args) {
    }

    static {
        OPR_MAP.put(1, "add");
        OPR_MAP.put(2, "subtract");
        OPR_MAP.put(3, "multiply");
        OPR_MAP.put(4, "divide");
        OPR_MAP.put(6, "less than");
        OPR_MAP.put(8, "less than or equal to");
        OPR_MAP.put(5, "greater than");
        OPR_MAP.put(7, "greater than or equal to");
        OPR_MAP.put(9, "equal to");
        OPR_MAP.put(10, "not equal to");
        STROPR_MAP = new HashMap();
        STROPR_MAP.put("add", "+");
        STROPR_MAP.put("subtract", "-");
        STROPR_MAP.put("multiply", "*");
        STROPR_MAP.put("divide", "/");
        STROPR_MAP.put("less than", "<");
        STROPR_MAP.put("less than or equal to", "<=");
        STROPR_MAP.put("greater than", ">");
        STROPR_MAP.put("greater than or equal to", ">=");
        STROPR_MAP.put("equal to", "=");
        STROPR_MAP.put("not equal to", "!=");
    }
}

