/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.configurations.AbstractSignature;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.formatter.Formattable;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParserFactory;

public class BoundParam
extends AbstractSignature
implements Formattable {
    private static final long serialVersionUID = 1L;
    protected Fact fact = null;
    protected Object resolvedVal = null;
    protected int column = -1;
    protected int valueType = -1;
    protected int rowId = -1;
    protected int actionType = 1000;
    protected String variableName = null;
    protected boolean isMultislot = false;

    public Object clone() {
        BoundParam result = new BoundParam();
        result.fact = this.fact;
        result.resolvedVal = this.resolvedVal;
        result.column = this.column;
        result.valueType = this.valueType;
        result.rowId = this.rowId;
        result.actionType = this.actionType;
        result.variableName = this.variableName;
        result.isMultislot = this.isMultislot;
        return result;
    }

    public BoundParam() {
    }

    public BoundParam(int col, int vType) {
        this.column = col;
        this.valueType = vType;
        this.objBinding = true;
    }

    public BoundParam(int col, int vType, boolean objBinding) {
        this.column = col;
        this.valueType = vType;
        this.objBinding = objBinding;
    }

    public BoundParam(int row, int col, int vType, boolean obj) {
        this.rowId = row;
        this.column = col;
        this.valueType = vType;
        this.objBinding = obj;
    }

    public BoundParam(Fact fact) {
        this.fact = fact;
        this.objBinding = true;
        this.valueType = 13;
    }

    public BoundParam(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String value) {
        this.variableName = value.substring(0, 1).equals("?") ? value.substring(1) : value;
    }

    public JamochaValue getValue(Engine engine) throws EvaluationException {
        if (this.fact != null && !this.objBinding) {
            return this.fact.getSlotValue(this.column);
        }
        if (this.fact != null) {
            return JamochaValue.newFact(this.fact);
        }
        return engine.getBinding(this.variableName);
    }

    public void setResolvedValue(Object val) {
        this.resolvedVal = val;
    }

    public Fact getFact() {
        return this.fact;
    }

    public void setFact(Fact[] facts) {
        if (this.rowId > -1 && facts[this.rowId] != null) {
            this.fact = facts[this.rowId];
        }
    }

    public boolean isFactBinding() {
        return this.objBinding;
    }

    public void setObjectBinding(boolean obj) {
        this.objBinding = obj;
    }

    public boolean isMultislot() {
        return this.isMultislot;
    }

    public void setIsMultislot(boolean multi) {
        this.isMultislot = multi;
    }

    public void setRow(int row) {
        this.rowId = row;
    }

    public void setColumn(int col) {
        this.column = col;
        if (this.column == -1) {
            this.objBinding = true;
        }
    }

    public void reset() {
        this.fact = null;
    }

    public String getExpressionString() {
        return ParserFactory.getFormatter().visit(this);
    }

    public String toString() {
        return this.getExpressionString();
    }

    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.rowId;
    }
}

