/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.messagerouter;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.CommunicationChannel;
import org.jamocha.communication.messagerouter.InterestType;
import org.jamocha.communication.messagerouter.StreamChannel;
import org.jamocha.communication.messagerouter.StreamChannelImpl;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.communication.messagerouter.StringChannelImpl;
import org.jamocha.engine.Engine;
import org.jamocha.parser.Expression;
import org.jamocha.parser.JamochaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRouter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, CommunicationChannel> idToChannel = new HashMap<String, CommunicationChannel>();
    private CommunicationChannel defaultChannel;
    private final Map<String, List<MessageEvent>> idToMessages = new HashMap<String, List<MessageEvent>>();
    private volatile String currentChannelId = "";
    private final Engine engine;
    private final Queue<CommandObject> commandQueue = new ConcurrentLinkedQueue<CommandObject>();
    private final Queue<MessageEvent> messageQueue = new ConcurrentLinkedQueue<MessageEvent>();
    private int idCounter = 0;
    private final CommandThread commandThread;

    public MessageRouter(Engine engine) {
        this.engine = engine;
        this.commandThread = new CommandThread();
        this.commandThread.start();
    }

    public Engine getReteEngine() {
        return this.engine;
    }

    public void postMessageEvent(MessageEvent event) {
        this.messageQueue.offer(event);
    }

    void enqueueCommand(Expression command, String channelId) {
        this.commandQueue.add(new CommandObject(command, channelId));
    }

    public StreamChannel openChannel(String channelName, InputStream inputStream) {
        return this.openChannel(channelName, inputStream, InterestType.MINE);
    }

    public StreamChannel openChannel(String channelName, InputStream inputStream, InterestType interestType) {
        StreamChannelImpl channel = new StreamChannelImpl(channelName + "_" + this.idCounter++, this, interestType);
        channel.init(inputStream);
        this.registerChannel(channel);
        return channel;
    }

    public StreamChannel openChannel(String channelName, Reader reader) {
        return this.openChannel(channelName, reader, InterestType.MINE);
    }

    public StreamChannel openChannel(String channelName, Reader reader, InterestType interestType) {
        StreamChannelImpl channel = new StreamChannelImpl(channelName + "_" + this.idCounter++, this, interestType);
        channel.init(reader);
        this.registerChannel(channel);
        return channel;
    }

    public StringChannel openChannel(String channelName) {
        return this.openChannel(channelName, InterestType.MINE);
    }

    public StringChannel openChannel(String channelName, InterestType interestType) {
        StringChannelImpl channel = new StringChannelImpl(channelName + "_" + this.idCounter++, this, interestType);
        this.registerChannel(channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(CommunicationChannel channel) {
        Map<String, CommunicationChannel> map = this.idToChannel;
        synchronized (map) {
            this.idToChannel.remove(channel.getChannelId());
            this.idToMessages.remove(channel.getChannelId());
            if (channel instanceof StreamChannelImpl) {
                ((StreamChannelImpl)channel).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillMessageList(String channelId, List<MessageEvent> destinationList) {
        Map<String, CommunicationChannel> map = this.idToChannel;
        synchronized (map) {
            List<MessageEvent> storedMessages = this.idToMessages.get(channelId);
            if (storedMessages != null && destinationList != null) {
                destinationList.addAll(storedMessages);
                storedMessages.clear();
            }
        }
    }

    public void dispose() {
        for (CommunicationChannel chan : this.idToChannel.values()) {
            this.closeChannel(chan);
        }
        this.commandThread.kill();
    }

    public String getCurrentChannelId() {
        return this.currentChannelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(CommunicationChannel channel) {
        Map<String, CommunicationChannel> map = this.idToChannel;
        synchronized (map) {
            this.idToChannel.put(channel.getChannelId(), channel);
            this.idToMessages.put(channel.getChannelId(), new ArrayList());
        }
    }

    public void setDefaultChannel(StreamChannel channel) {
        this.defaultChannel = channel;
    }

    public String getDefaultChannelId() {
        return this.defaultChannel != null ? this.defaultChannel.getChannelId() : "";
    }

    private static final class CommandObject {
        private final Expression command;
        private final String channelId;

        private CommandObject(Expression command, String channelId) {
            this.command = command;
            this.channelId = channelId;
        }
    }

    private final class CommandThread
    extends Thread {
        private boolean shouldBeKilled = false;

        private CommandThread() {
        }

        public void kill() {
            this.shouldBeKilled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: while (true) {
                if (MessageRouter.this.commandQueue.isEmpty()) {
                    if (this.shouldBeKilled) {
                        return;
                    }
                    try {
                        CommandThread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                } else {
                    CommandObject schabau = (CommandObject)MessageRouter.this.commandQueue.poll();
                    if (schabau != null) {
                        MessageRouter.this.currentChannelId = schabau.channelId;
                        try {
                            MessageRouter.this.messageQueue.offer(new MessageEvent(MessageEvent.MessageEventType.COMMAND, schabau.command, MessageRouter.this.currentChannelId));
                            JamochaValue result = schabau.command.getValue(MessageRouter.this.engine);
                            MessageRouter.this.messageQueue.offer(new MessageEvent(MessageEvent.MessageEventType.RESULT, result, MessageRouter.this.currentChannelId));
                        }
                        catch (Exception e) {
                            MessageRouter.this.postMessageEvent(new MessageEvent(MessageEvent.MessageEventType.ERROR, e, MessageRouter.this.currentChannelId));
                        }
                        finally {
                            MessageRouter.this.currentChannelId = null;
                        }
                    }
                }
                ArrayList allMessages = new ArrayList(MessageRouter.this.messageQueue);
                MessageRouter.this.messageQueue.clear();
                int i = 0;
                while (true) {
                    if (i >= allMessages.size()) continue block10;
                    MessageEvent event = (MessageEvent)allMessages.get(i);
                    Map map = MessageRouter.this.idToChannel;
                    synchronized (map) {
                        for (CommunicationChannel channel : MessageRouter.this.idToChannel.values()) {
                            List messageList;
                            if (!InterestType.ALL.equals((Object)channel.getInterest()) && (!InterestType.MINE.equals((Object)channel.getInterest()) || !channel.getChannelId().equals(event.getChannelId())) || (messageList = (List)MessageRouter.this.idToMessages.get(channel.getChannelId())) == null) continue;
                            messageList.add(event);
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

