/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logging {
    private static Map<String, JamochaLogger> loggers = new HashMap<String, JamochaLogger>();

    public static JamochaLogger logger(Class<? extends Object> clz) {
        return Logging.logger(clz.getCanonicalName());
    }

    public static JamochaLogger logger(String className) {
        JamochaLogger res = loggers.get(className);
        if (res == null) {
            Logger julLogger = Logger.getLogger(className);
            res = new JamochaLogger(julLogger);
            loggers.put(className, res);
        }
        return res;
    }

    public static class JamochaLogger {
        private final Logger log;

        private JamochaLogger(Logger log) {
            this.log = log;
        }

        public void debug(String msg) {
            this.log.log(Level.FINE, msg);
        }

        public void debug(Exception exc) {
            this.log.log(Level.FINE, exc.getMessage(), exc);
            exc.printStackTrace();
        }

        public void info(String msg) {
            this.log.log(Level.INFO, msg);
        }

        public void info(Exception exc) {
            this.log.log(Level.INFO, exc.getMessage(), exc);
            exc.printStackTrace();
        }

        public void warn(String msg) {
            this.log.log(Level.WARNING, msg);
        }

        public void warn(Exception exc) {
            this.log.log(Level.WARNING, exc.getMessage(), exc);
            exc.printStackTrace();
        }

        public void fatal(String msg) {
            this.log.log(Level.SEVERE, msg);
        }

        public void fatal(Exception exc) {
            this.log.log(Level.SEVERE, exc.getMessage(), exc);
            exc.printStackTrace();
        }
    }
}

