/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.agent;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.tools.ToolAgent;
import jade.util.BasicProperties;
import jade.util.ExpandedProperties;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.jamocha.Constants;
import org.jamocha.application.Jamocha;
import org.jamocha.communication.agent.MessageReceiver;
import org.jamocha.communication.agent.MessageSender;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.agent.AgentFunctions;
import org.jamocha.parser.ParserUtils;

public class JamochaAgent
extends ToolAgent {
    private static final String INIT_FILE_NAME = "communication/agent/initial/init.clp";
    public static final String TEMPLATE_AGENT_DESCRIPTION = "agent-identifier";
    public static final String TEMPLATE_AGENT_MESSAGE = "agent-message";
    private static final long serialVersionUID = 1L;
    private Engine engine;
    private final String STANDARD_PROP_FILE = "Agent.properties";
    private BasicProperties properties = null;
    private String[] arguments;
    private MessageSender sendingBehaviour;
    private Jamocha jamocha;
    StringChannel initChannel;

    public void toolSetup() {
        this.initProperties();
        this.jamocha = new Jamocha(this.getProperties().getBooleanProperty("jamocha.gui", false), this.getProperties().getBooleanProperty("jamoche.shell", false), null);
        if (this.getProperties().getBooleanProperty("jamocha.gui", false)) {
            this.jamocha.getJamochaGui().setExitOnClose(false);
            this.jamocha.setGUITitle("JamochaAgent - " + this.getName());
        }
        this.engine = this.jamocha.getEngine();
        this.addBehaviour((Behaviour)new MessageReceiver(this));
        this.sendingBehaviour = new MessageSender(this);
        this.addBehaviour((Behaviour)this.sendingBehaviour);
        this.initChannel = this.engine.getMessageRouter().openChannel(this.getProperties().getProperty("agent.name", "Agent") + "init");
        this.initEngine();
        this.initAgentWithProperties();
        LinkedList<String> batchFiles = new LinkedList<String>();
        String batchString = this.getProperties().getProperty("jamocha.batch", "");
        if (!batchString.equals("")) {
            String[] batchArr;
            for (String batchFile : batchArr = batchString.split(",")) {
                batchFiles.add(batchFile);
            }
        }
        this.jamocha.batchFiles(batchFiles);
        this.initChannel.executeCommand(ParserUtils.getStringLiteral(this.getProperties().getProperty("jamocha.clips", "")), true);
        this.engine.getMessageRouter().closeChannel(this.initChannel);
        if (this.getProperties().getBooleanProperty("agent.debug", false)) {
            LinkedList<MessageEvent> events = new LinkedList<MessageEvent>();
            this.initChannel.fillEventList(events);
            for (MessageEvent event : events) {
                if (event.getMessage() instanceof Exception) {
                    ((Exception)event.getMessage()).printStackTrace();
                    continue;
                }
                if (event.getMessage() instanceof Function) {
                    System.out.println(((Function)event.getMessage()).getName());
                    continue;
                }
                System.out.println(event.getMessage());
            }
        }
    }

    private void initEngine() {
        AgentFunctions agentFuncs = new AgentFunctions(this);
        this.engine.getFunctionMemory().declareFunctionGroup(agentFuncs);
        this.engine.getFunctionMemory().registerBuildInFunctionGroup(agentFuncs);
        StringBuilder buffer = new StringBuilder();
        try {
            this.readFile(buffer, INIT_FILE_NAME);
            String pathProtocols = this.getProperties().getProperty("agent.protocols", "");
            if (pathProtocols.equals("")) {
                this.readPath(buffer, pathProtocols);
            }
            this.readPath(buffer, "communication/agent/performatives");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        buffer.append("(assert (agent-is-local (agent (assert (");
        buffer.append(TEMPLATE_AGENT_DESCRIPTION).append("(name \"");
        buffer.append(this.getName()).append("\"))))))");
        try {
            this.initChannel.executeCommand(buffer.toString(), true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void initAgentWithProperties() {
        String dfName = this.getProperties().getProperty("agent.df.name", "undefined");
        String dfAddress = this.getProperties().getProperty("agent.df.address", "undefined");
        if (!dfName.equals("undefined") && !dfAddress.equals("undefined")) {
            AID myDF = new AID(dfName, true);
            myDF.addAddresses(dfAddress);
            DFAgentDescription dfd = new DFAgentDescription();
            ServiceDescription sd = new ServiceDescription();
            sd.setName(this.getName());
            String dfType = this.getProperties().getProperty("agent.df.type", "undefined");
            String dfOwnership = this.getProperties().getProperty("agent.df.ownership", "undefined");
            sd.setType(dfType);
            sd.setOwnership(dfOwnership);
            dfd.setName(this.getAID());
            dfd.addServices(sd);
            try {
                DFAgentDescription actualDfd = DFService.register((Agent)this, (AID)myDF, (DFAgentDescription)dfd);
                DFService.keepRegistered((Agent)this, (AID)myDF, (DFAgentDescription)actualDfd, null);
            }
            catch (FIPAException fe) {
                fe.printStackTrace();
            }
        }
    }

    private void initProperties() {
        Object[] arguments;
        this.properties = new ExpandedProperties();
        String defaultPropName = "Agent.properties";
        try {
            defaultPropName = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/" + defaultPropName;
        }
        catch (Exception any) {
            // empty catch block
        }
        InputStream propertyStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(defaultPropName);
        if (propertyStream != null) {
            try {
                this.properties.load(propertyStream);
            }
            catch (IOException ioe) {
                System.err.println("Error reading:" + defaultPropName);
                System.exit(-1);
            }
        }
        if ((arguments = super.getArguments()) != null) {
            String[] stringArgs = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                stringArgs[i] = arguments[i].toString();
                System.out.print("arg[" + i + "]: " + (String)arguments[i] + "\n");
            }
            this.setArguments(stringArgs);
        }
        if (this.getProperties().getBooleanProperty("agent.debug", false)) {
            System.out.println("----- " + this.getLocalName() + "'s properties:");
            this.getProperties().list(System.out);
            System.out.println("----- end of properties -----");
        }
    }

    public MessageSender getMessageSender() {
        return this.sendingBehaviour;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setProperties(BasicProperties aProperties) {
        this.properties = aProperties;
    }

    public BasicProperties getProperties() {
        return this.properties;
    }

    public void setArguments(String[] args) {
        this.arguments = args;
        ExpandedProperties newProperties = new ExpandedProperties();
        newProperties.copyProperties(this.getProperties());
        newProperties.parseArgs(args);
        this.setProperties((BasicProperties)newProperties);
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    private void readFile(StringBuilder buffer, String fileName) throws IOException {
        InputStream is = Constants.class.getResourceAsStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
        while (reader.ready()) {
            buffer.append(reader.readLine() + "\n");
        }
        reader.close();
    }

    private void readPath(StringBuilder buffer, String path) throws IOException {
    }
}

