/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.settings.AbstractSettingsPanel;

public class GUISettingsPanel
extends AbstractSettingsPanel
implements ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = -7136144663514250335L;
    private final JComboBox fonts;
    private final JComboBox fontsizes;
    private final JButton fontColorChooserButton;
    private final JTextField fontColorChooserPreview;
    private final JButton backgroundColorChooserButton;
    private final JTextField backgroundColorChooserPreview;
    private final JComboBox factSortByCombo;
    private final JComboBox factSortDirectionCombo;
    private final JCheckBox autoCompletion;
    private final Font[] allFonts;

    public GUISettingsPanel(JamochaGui gui) {
        super(gui);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        JPanel shellPanel = new JPanel();
        shellPanel.setLayout(gridbag);
        shellPanel.setBorder(BorderFactory.createTitledBorder("Shell"));
        this.addLabel(shellPanel, new JLabel("Font:"), gridbag, c, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.allFonts = ge.getAllFonts();
        this.filterFonts(this.allFonts);
        this.fonts = new JComboBox<Font>(this.allFonts);
        this.fonts.setRenderer(new FontListCellRenderer());
        this.fonts.addItemListener(this);
        JPanel fontsPanel = new JPanel(new BorderLayout());
        fontsPanel.add((Component)this.fonts, "West");
        this.addInputComponent(shellPanel, fontsPanel, gridbag, c, 0);
        this.addLabel(shellPanel, new JLabel("Fontsize:"), gridbag, c, 1);
        Integer[] sizes = new Integer[17];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = 8 + i;
        }
        this.fontsizes = new JComboBox<Integer>(sizes);
        this.fontsizes.setSelectedItem(this.settings.getInt("gui.shell.fontsize"));
        this.fontsizes.addItemListener(this);
        JPanel fontsizesPanel = new JPanel(new BorderLayout());
        fontsizesPanel.add((Component)this.fontsizes, "West");
        this.addInputComponent(shellPanel, fontsizesPanel, gridbag, c, 1);
        this.addLabel(shellPanel, new JLabel("Fontcolor:"), gridbag, c, 2);
        JPanel fontColorChooserPanel = new JPanel(new FlowLayout(0));
        this.fontColorChooserPreview = new JTextField(5);
        this.fontColorChooserPreview.setEditable(false);
        this.fontColorChooserPreview.setBackground(new Color(this.settings.getInt("gui.shell.fontcolor")));
        this.fontColorChooserButton = new JButton("Choose Color", IconLoader.getImageIcon("color_swatch"));
        this.fontColorChooserButton.addActionListener(this);
        fontColorChooserPanel.add(this.fontColorChooserPreview);
        fontColorChooserPanel.add(this.fontColorChooserButton);
        this.addInputComponent(shellPanel, fontColorChooserPanel, gridbag, c, 2);
        this.addLabel(shellPanel, new JLabel("Backgroundcolor:"), gridbag, c, 3);
        JPanel backgroundColorChooserPanel = new JPanel(new FlowLayout(0));
        this.backgroundColorChooserPreview = new JTextField(5);
        this.backgroundColorChooserPreview.setEditable(false);
        this.backgroundColorChooserPreview.setBackground(new Color(this.settings.getInt("gui.shell.backgroundcolor")));
        this.backgroundColorChooserButton = new JButton("Choose Color", IconLoader.getImageIcon("color_swatch"));
        this.backgroundColorChooserButton.addActionListener(this);
        backgroundColorChooserPanel.add(this.backgroundColorChooserPreview);
        backgroundColorChooserPanel.add(this.backgroundColorChooserButton);
        this.addInputComponent(shellPanel, backgroundColorChooserPanel, gridbag, c, 3);
        this.addLabel(shellPanel, new JLabel(""), gridbag, c, 4);
        this.autoCompletion = new JCheckBox("Enable Auto-Completion");
        this.autoCompletion.setSelected(this.settings.getBoolean("gui.shell.autocompletion"));
        this.autoCompletion.addChangeListener(this);
        this.addInputComponent(shellPanel, this.autoCompletion, gridbag, c, 4);
        mainPanel.add(shellPanel);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        c.weightx = 1.0;
        JPanel factsPanel = new JPanel();
        factsPanel.setLayout(gridbag);
        factsPanel.setBorder(BorderFactory.createTitledBorder("Facts"));
        this.addLabel(factsPanel, new JLabel("Auto sort Facts by:"), gridbag, c, 1);
        String[] factSortBy = new String[]{"no sorting", "id", "template", "fact"};
        this.factSortByCombo = new JComboBox<String>(factSortBy);
        this.factSortByCombo.setSelectedItem(this.settings.getString("gui.facts.autosort_by"));
        this.factSortByCombo.addItemListener(this);
        JPanel factSortByPanel = new JPanel(new BorderLayout());
        factSortByPanel.add((Component)this.factSortByCombo, "West");
        this.addInputComponent(factsPanel, factSortByPanel, gridbag, c, 1);
        this.addLabel(factsPanel, new JLabel("direction:"), gridbag, c, 2);
        String[] factSortDirection = new String[]{"ascending", "descending"};
        this.factSortDirectionCombo = new JComboBox<String>(factSortDirection);
        this.factSortDirectionCombo.setSelectedItem(this.settings.getString("gui.facts.autosort_dir"));
        this.factSortDirectionCombo.addItemListener(this);
        JPanel factSortDirectionPanel = new JPanel(new BorderLayout());
        factSortDirectionPanel.add((Component)this.factSortDirectionCombo, "West");
        this.addInputComponent(factsPanel, factSortDirectionPanel, gridbag, c, 2);
        mainPanel.add(factsPanel);
        this.add(new JScrollPane(mainPanel));
    }

    private Font[] filterFonts(Font[] fonts) {
        LinkedList<Font> res = new LinkedList<Font>();
        for (Font font : fonts) {
            if (!font.getName().matches("(.*)[M|m]ono(.*)") && !font.getFamily().matches("(.*)[M|m]ono(.*)") && !font.getName().matches("Monaco") && !font.getName().matches("(.*)[C|c]ourier(.*)")) continue;
            res.add(font);
        }
        fonts = new Font[res.size()];
        for (int i = 0; i < fonts.length; ++i) {
            fonts[i] = (Font)res.get(i);
        }
        return fonts;
    }

    public void actionPerformed(ActionEvent event) {
        Color newColor;
        if (event.getSource() == this.fontColorChooserButton) {
            Color newColor2 = JColorChooser.showDialog(this, "Choose a Fontcolor", new Color(this.settings.getInt("gui.shell.fontcolor")));
            if (newColor2 != null) {
                this.fontColorChooserPreview.setBackground(newColor2);
                this.settings.set("gui.shell.fontcolor", newColor2.getRGB());
            }
        } else if (event.getSource() == this.backgroundColorChooserButton && (newColor = JColorChooser.showDialog(this, "Choose a Backgroundcolor", new Color(this.settings.getInt("gui.shell.backgroundcolor")))) != null) {
            this.backgroundColorChooserPreview.setBackground(newColor);
            this.settings.set("gui.shell.backgroundcolor", newColor.getRGB());
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource().equals(this.fonts)) {
            this.settings.set("gui.shell.font", ((Font)this.fonts.getSelectedItem()).getFontName());
        } else if (event.getSource().equals(this.fontsizes)) {
            this.settings.set("gui.shell.fontsize", (Integer)this.fontsizes.getSelectedItem());
        } else if (event.getSource().equals(this.factSortByCombo)) {
            this.settings.set("gui.facts.autosort_by", this.factSortByCombo.getSelectedItem().toString());
        } else if (event.getSource().equals(this.factSortDirectionCombo)) {
            this.settings.set("gui.facts.autosort_dir", this.factSortDirectionCombo.getSelectedItem().toString());
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource().equals(this.autoCompletion)) {
            this.settings.set("gui.shell.autocompletion", this.autoCompletion.isSelected());
        }
    }

    public void refresh() {
        String selFontName = this.settings.getString("gui.shell.font");
        for (Font curFont : this.allFonts) {
            if (!curFont.getFontName().equals(selFontName)) continue;
            this.fonts.setSelectedItem(curFont);
            break;
        }
        this.fontsizes.setSelectedItem(this.settings.getInt("gui.shell.fontsize"));
        this.fontColorChooserPreview.setBackground(new Color(this.settings.getInt("gui.shell.fontcolor")));
        this.backgroundColorChooserPreview.setBackground(new Color(this.settings.getInt("gui.shell.backgroundcolor")));
        this.autoCompletion.setSelected(this.settings.getBoolean("gui.shell.autocompletion"));
        this.factSortByCombo.setSelectedItem(this.settings.getString("gui.facts.autosort_by"));
        this.factSortDirectionCombo.setSelectedItem(this.settings.getString("gui.facts.autosort_dir"));
    }

    public void setDefaults() {
        this.settings.toDefault("gui.shell.font");
        this.settings.toDefault("gui.shell.fontsize");
        this.settings.toDefault("gui.shell.fontcolor");
        this.settings.toDefault("gui.shell.backgroundcolor");
        this.settings.toDefault("gui.shell.autocompletion");
        this.settings.toDefault("gui.facts.autosort_by");
        this.settings.toDefault("gui.facts.autosort_dir");
        this.refresh();
    }

    private class FontListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setFont(((Font)value).deriveFont(12.0f));
            this.setText(((Font)value).getFontName());
            return this;
        }
    }
}

