/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.tab.settings.AbstractSettingsPanel;
import org.jamocha.engine.agenda.ConflictResolutionStrategy;
import org.jamocha.engine.modules.Module;

public class EngineSettingsPanel
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = -7136144663514250335L;
    private final JCheckBox evaluationCheckBox;
    private final JCheckBox profileAssertCheckBox;
    private final JCheckBox profileRetractCheckBox;
    private final JCheckBox profileFireCheckBox;
    private final JCheckBox profileAddActivationCheckBox;
    private final JCheckBox profileRemoveActivationCheckBox;
    private final JCheckBox watchActivationsCheckBox;
    private final JCheckBox watchFactsCheckBox;
    private final JCheckBox watchRulesCheckBox;
    private final JCheckBox shareNodesCheckBox;
    private final JComboBox strategySelectorMain;
    private final JComboBox moduleSelector;
    private final JComboBox strategySelector;

    public EngineSettingsPanel(JamochaGui gui) {
        super(gui);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        JPanel generalSettingsPanel = new JPanel();
        generalSettingsPanel.setLayout(gridbag);
        generalSettingsPanel.setBorder(BorderFactory.createTitledBorder("General Settings"));
        this.addLabel(generalSettingsPanel, new JLabel("Evaluation:"), gridbag, c, 0);
        JPanel evaluationPanel = new JPanel(new BorderLayout());
        this.evaluationCheckBox = new JCheckBox();
        this.evaluationCheckBox.addActionListener(this);
        evaluationPanel.add((Component)this.evaluationCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, evaluationPanel, gridbag, c, 0);
        this.addLabel(generalSettingsPanel, new JLabel("Profile Assert:"), gridbag, c, 1);
        JPanel profileAssertPanel = new JPanel(new BorderLayout());
        this.profileAssertCheckBox = new JCheckBox();
        this.profileAssertCheckBox.addActionListener(this);
        profileAssertPanel.add((Component)this.profileAssertCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, profileAssertPanel, gridbag, c, 1);
        this.addLabel(generalSettingsPanel, new JLabel("Profile Retract:"), gridbag, c, 2);
        JPanel profileRetractPanel = new JPanel(new BorderLayout());
        this.profileRetractCheckBox = new JCheckBox();
        this.profileRetractCheckBox.addActionListener(this);
        profileRetractPanel.add((Component)this.profileRetractCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, profileRetractPanel, gridbag, c, 2);
        this.addLabel(generalSettingsPanel, new JLabel("Profile Fire:"), gridbag, c, 3);
        JPanel profileFirePanel = new JPanel(new BorderLayout());
        this.profileFireCheckBox = new JCheckBox();
        this.profileFireCheckBox.addActionListener(this);
        profileFirePanel.add((Component)this.profileFireCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, profileFirePanel, gridbag, c, 3);
        this.addLabel(generalSettingsPanel, new JLabel("Profile Add Activation:"), gridbag, c, 4);
        JPanel profileAddActivationPanel = new JPanel(new BorderLayout());
        this.profileAddActivationCheckBox = new JCheckBox();
        this.profileAddActivationCheckBox.addActionListener(this);
        profileAddActivationPanel.add((Component)this.profileAddActivationCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, profileAddActivationPanel, gridbag, c, 4);
        this.addLabel(generalSettingsPanel, new JLabel("Profile Remove Activation:"), gridbag, c, 5);
        JPanel profileRemoveActivationPanel = new JPanel(new BorderLayout());
        this.profileRemoveActivationCheckBox = new JCheckBox();
        this.profileRemoveActivationCheckBox.addActionListener(this);
        profileRemoveActivationPanel.add((Component)this.profileRemoveActivationCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, profileRemoveActivationPanel, gridbag, c, 5);
        this.addLabel(generalSettingsPanel, new JLabel("Watch Activations:"), gridbag, c, 6);
        JPanel watchActivationsPanel = new JPanel(new BorderLayout());
        this.watchActivationsCheckBox = new JCheckBox();
        this.watchActivationsCheckBox.addActionListener(this);
        watchActivationsPanel.add((Component)this.watchActivationsCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, watchActivationsPanel, gridbag, c, 6);
        this.addLabel(generalSettingsPanel, new JLabel("Watch Facts:"), gridbag, c, 7);
        JPanel watchFactsPanel = new JPanel(new BorderLayout());
        this.watchFactsCheckBox = new JCheckBox();
        this.watchFactsCheckBox.addActionListener(this);
        watchFactsPanel.add((Component)this.watchFactsCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, watchFactsPanel, gridbag, c, 7);
        this.addLabel(generalSettingsPanel, new JLabel("Watch Rules:"), gridbag, c, 8);
        JPanel watchRulesPanel = new JPanel(new BorderLayout());
        this.watchRulesCheckBox = new JCheckBox();
        this.watchRulesCheckBox.addActionListener(this);
        watchRulesPanel.add((Component)this.watchRulesCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, watchRulesPanel, gridbag, c, 8);
        this.addLabel(generalSettingsPanel, new JLabel("Share Nodes:"), gridbag, c, 9);
        JPanel shareNodesPanel = new JPanel(new BorderLayout());
        this.shareNodesCheckBox = new JCheckBox();
        this.shareNodesCheckBox.addActionListener(this);
        shareNodesPanel.add((Component)this.shareNodesCheckBox, "West");
        this.addInputComponent(generalSettingsPanel, shareNodesPanel, gridbag, c, 9);
        mainPanel.add(generalSettingsPanel);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        c.weightx = 1.0;
        JPanel moduleSettingsPanel = new JPanel();
        moduleSettingsPanel.setLayout(gridbag);
        moduleSettingsPanel.setBorder(BorderFactory.createTitledBorder("Strategy Settings"));
        this.addLabel(moduleSettingsPanel, new JLabel("Strategy for MAIN:"), gridbag, c, 0);
        JPanel strategyPanelMain = new JPanel(new BorderLayout());
        this.strategySelectorMain = new JComboBox();
        this.strategySelectorMain.addActionListener(this);
        strategyPanelMain.add((Component)this.strategySelectorMain, "West");
        this.addInputComponent(moduleSettingsPanel, strategyPanelMain, gridbag, c, 0);
        this.addLabel(moduleSettingsPanel, new JLabel("Other Modules:"), gridbag, c, 1);
        JPanel modulePanel = new JPanel(new BorderLayout());
        this.moduleSelector = new JComboBox();
        this.moduleSelector.addActionListener(this);
        modulePanel.add((Component)this.moduleSelector, "West");
        this.addInputComponent(moduleSettingsPanel, modulePanel, gridbag, c, 1);
        this.addLabel(moduleSettingsPanel, new JLabel(""), gridbag, c, 2);
        JPanel strategyPanel = new JPanel(new BorderLayout());
        this.strategySelector = new JComboBox();
        this.strategySelector.addActionListener(this);
        strategyPanel.add((Component)this.strategySelector, "West");
        this.addInputComponent(moduleSettingsPanel, strategyPanel, gridbag, c, 2);
        mainPanel.add(moduleSettingsPanel);
        this.add(new JScrollPane(mainPanel));
        this.addLabel(moduleSettingsPanel, new JLabel("Attention:"), gridbag, c, 3);
        JTextArea attentionField = new JTextArea();
        attentionField.setEditable(false);
        attentionField.setBorder(BorderFactory.createEmptyBorder());
        attentionField.setBackground(gui.getBackground());
        attentionField.setText("Changes you make here are lost after a restart.\nOnly the settings for MAIN-module are made persistent.");
        this.addInputComponent(moduleSettingsPanel, attentionField, gridbag, c, 3);
        mainPanel.add(moduleSettingsPanel);
        this.add(new JScrollPane(mainPanel));
    }

    public void refresh() {
        this.initStrategySelectorMain();
        this.initModuleSelector();
        this.initStrategySelector();
        this.evaluationCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.evaluation"));
        this.profileAssertCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.profile_assert"));
        this.profileRetractCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.profile_retract"));
        this.profileFireCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.profile_fire"));
        this.profileAddActivationCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.profile_add_activation"));
        this.profileRemoveActivationCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.profile_remove_activation"));
        this.watchActivationsCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.watch_activations"));
        this.watchFactsCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.watch_facts"));
        this.watchRulesCheckBox.setSelected(this.settings.getBoolean("engine.general_settings.watch_rules"));
        this.shareNodesCheckBox.setSelected(this.settings.getBoolean("engine.net_settings.share_nodes"));
        this.strategySelectorMain.setSelectedItem(this.settings.getString("engine.strategy_settings.strategy_main"));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.evaluationCheckBox) {
            this.settings.set("engine.general_settings.evaluation", this.evaluationCheckBox.isSelected());
        } else if (event.getSource() == this.profileAssertCheckBox) {
            this.settings.set("engine.general_settings.profile_assert", this.profileAssertCheckBox.isSelected());
        } else if (event.getSource() == this.profileRetractCheckBox) {
            this.settings.set("engine.general_settings.profile_retract", this.profileRetractCheckBox.isSelected());
        } else if (event.getSource() == this.profileFireCheckBox) {
            this.settings.set("engine.general_settings.profile_fire", this.profileFireCheckBox.isSelected());
        } else if (event.getSource() == this.profileAddActivationCheckBox) {
            this.settings.set("engine.general_settings.profile_add_activation", this.profileAddActivationCheckBox.isSelected());
        } else if (event.getSource() == this.profileRemoveActivationCheckBox) {
            this.settings.set("engine.general_settings.profile_remove_activation", this.profileRemoveActivationCheckBox.isSelected());
        } else if (event.getSource() == this.watchActivationsCheckBox) {
            this.settings.set("engine.general_settings.watch_activations", this.watchActivationsCheckBox.isSelected());
        } else if (event.getSource() == this.watchFactsCheckBox) {
            this.settings.set("engine.general_settings.watch_facts", this.watchFactsCheckBox.isSelected());
        } else if (event.getSource() == this.watchRulesCheckBox) {
            this.settings.set("engine.general_settings.watch_rules", this.watchRulesCheckBox.isSelected());
        } else if (event.getSource() == this.shareNodesCheckBox) {
            this.settings.set("engine.net_settings.share_nodes", this.shareNodesCheckBox.isSelected());
        } else if (event.getSource().equals(this.strategySelectorMain)) {
            if (this.strategySelectorMain.getSelectedItem() != null) {
                String strategyName = this.strategySelectorMain.getSelectedItem().toString();
                this.settings.set("engine.strategy_settings.strategy_main", strategyName);
            }
        } else if (event.getSource().equals(this.moduleSelector)) {
            this.initStrategySelector();
        } else if (event.getSource().equals(this.strategySelector) && this.strategySelector.getSelectedItem() != null && this.moduleSelector.getSelectedItem() != null) {
            String strategyName = this.strategySelector.getSelectedItem().toString();
            String moduleName = this.moduleSelector.getSelectedItem().toString();
            Module module = this.gui.getEngine().getModule(moduleName);
            try {
                this.gui.getEngine().getAgendas().getAgenda(module).setConflictResolutionStrategy(ConflictResolutionStrategy.getStrategy(strategyName));
            }
            catch (InstantiationException e) {
                JOptionPane.showMessageDialog(this, e, "Error setting the strategy.", 0);
            }
            catch (IllegalAccessException e) {
                JOptionPane.showMessageDialog(this, e, "Error setting the strategy.", 0);
            }
        }
    }

    private void initModuleSelector() {
        this.moduleSelector.removeAllItems();
        Collection<Module> modules = this.gui.getEngine().getModules().getModuleList();
        for (Module module : modules) {
            if (module.getName().equals("MAIN")) continue;
            this.moduleSelector.addItem(module.getName());
        }
        if (this.moduleSelector.getItemCount() > 0) {
            this.moduleSelector.setSelectedIndex(0);
            this.moduleSelector.setEnabled(true);
        } else {
            this.moduleSelector.setEnabled(false);
        }
    }

    private void initStrategySelector() {
        this.strategySelector.removeAllItems();
        if (this.moduleSelector.getSelectedItem() != null) {
            this.strategySelector.setEnabled(true);
            String moduleName = this.moduleSelector.getSelectedItem().toString();
            Module module = this.gui.getEngine().getModule(moduleName);
            ConflictResolutionStrategy currentStrategy = this.gui.getEngine().getAgendas().getAgenda(module).getConflictResolutionStrategy();
            Set<String> strategies = ConflictResolutionStrategy.getStrategies();
            for (String strategyName : strategies) {
                this.strategySelector.addItem(strategyName);
                if (!strategyName.equals(currentStrategy.getName())) continue;
                this.strategySelector.setSelectedItem(strategyName);
            }
        } else {
            this.strategySelector.setEnabled(false);
        }
    }

    private void initStrategySelectorMain() {
        this.strategySelectorMain.removeAllItems();
        String currName = this.settings.getString("engine.strategy_settings.strategy_main");
        Set<String> strategies = ConflictResolutionStrategy.getStrategies();
        for (String strategyName : strategies) {
            this.strategySelectorMain.addItem(strategyName);
            if (!strategyName.equals(currName)) continue;
            this.strategySelectorMain.setSelectedItem(strategyName);
        }
    }

    public void setDefaults() {
        this.settings.toDefault("engine.general_settings.evaluation");
        this.settings.toDefault("engine.general_settings.profile_assert");
        this.settings.toDefault("engine.general_settings.profile_retract");
        this.settings.toDefault("engine.general_settings.profile_fire");
        this.settings.toDefault("engine.general_settings.profile_add_activation");
        this.settings.toDefault("engine.general_settings.profile_remove_activation");
        this.settings.toDefault("engine.general_settings.watch_activations");
        this.settings.toDefault("engine.general_settings.watch_facts");
        this.settings.toDefault("engine.general_settings.watch_rules");
        this.settings.toDefault("engine.net_settings.share_nodes");
        this.settings.toDefault("engine.strategy_settings.strategy_main");
        this.refresh();
    }
}

