/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.retevisualisation.UnknownConnectorTypeException;
import org.jamocha.application.gui.retevisualisation.VisualizerPanel;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.settings.SettingsChangedListener;

public class ViewerPanel
extends AbstractJamochaPanel {
    private static final long serialVersionUID = -5732131176258158968L;
    VisualizerPanel visualizer;

    public ViewerPanel(JamochaGui gui) {
        super(gui);
        this.visualizer = new VisualizerPanel(gui.getEngine());
        this.setLayout(new BorderLayout());
        this.add((Component)this.visualizer, "Center");
        String[] settingNames = new String[]{"gui.viewer.connectortype"};
        ViewerSettingsChangedListener listener = new ViewerSettingsChangedListener();
        this.settings.addListener(listener, settingNames);
        this.readSettings();
    }

    protected void readSettings() {
        String connType = this.settings.getString("gui.viewer.connectortype");
        try {
            this.visualizer.setConnectorType(connType);
        }
        catch (UnknownConnectorTypeException e) {
            this.gui.getEngine().writeMessage(e.toString());
        }
    }

    public void close() {
        this.settings.set("gui.viewer.connectortype", this.visualizer.getConnectorType());
    }

    private class ViewerSettingsChangedListener
    implements SettingsChangedListener {
        private ViewerSettingsChangedListener() {
        }

        public void settingsChanged(String propertyName) {
            ViewerPanel.this.readSettings();
        }
    }
}

