/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import org.jamocha.application.gui.ClipboardUtil;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.application.gui.tab.AutoCompletion;
import org.jamocha.application.gui.tab.AutoCompletionBox;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.StreamChannel;
import org.jamocha.engine.functions.Function;
import org.jamocha.parser.JamochaValue;
import org.jamocha.settings.SettingsChangedListener;

public class ShellPanel
extends AbstractJamochaPanel
implements ActionListener,
AdjustmentListener,
SettingsChangedListener {
    private static final long serialVersionUID = 1777454004380892575L;
    private final AutoCompletion autoCompletion;
    private final AutoCompletionBox autoCompletionBox;
    private String autoCompletionPrefix;
    private boolean enableAutoCompletion = false;
    private boolean running = true;
    private final Queue<KeyEvent> keyEventQueue = new ConcurrentLinkedQueue<KeyEvent>();
    private final JTextArea outputArea;
    private final JScrollPane scrollPane;
    private final JButton clearButton;
    private int history_offset = 0;
    private final int history_max_size = 100;
    private final List<String> history = new LinkedList<String>();
    private String history_activeline = "";
    private int lastPromptIndex = 0;
    private static final String SHELL_CURSOR = "_";
    private int cursorPosition = 0;
    private String cursorSubString = "";
    private final Timer cursorTimer = new Timer(400, this);
    private boolean cursorShowing = false;
    private int lastScrollBarPosition = 0;
    private StreamChannel channel;
    private Writer outWriter;
    private StringBuilder lastIncompleteCommand = new StringBuilder();
    private Thread channelListener;
    private boolean channelListenerPaused = false;
    private final String[] interestedSettings = new String[]{"gui.shell.font", "gui.shell.fontsize", "gui.shell.fontcolor", "gui.shell.backgroundcolor", "gui.shell.autocompletion"};

    private void initAutoCompletion() {
        this.autoCompletion.addToken("multislot");
        this.autoCompletion.addToken("slot");
        for (Function function : this.gui.getEngine().getFunctionMemory().getAllFunctions()) {
            StringBuilder longName = new StringBuilder();
            longName.append(function.getName());
            for (int i = 0; i < function.getDescription().getParameterCount(); ++i) {
                longName.append(" ").append(function.getDescription().getParameterName(i).replace(" ", SHELL_CURSOR));
            }
            longName.append(")");
            this.autoCompletion.addToken(function.getName(), longName.toString());
        }
    }

    public ShellPanel(JamochaGui gui) {
        super(gui);
        this.autoCompletion = new AutoCompletion();
        this.autoCompletionBox = new AutoCompletionBox(gui, this.autoCompletion, this);
        this.outputArea = new JTextArea(){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
                if (id == 0 || id == 1) {
                    return Collections.emptySet();
                }
                return super.getFocusTraversalKeys(id);
            }
        };
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        this.outputArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.outputArea, 20, 31);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.scrollPane.setAutoscrolls(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.clearButton = new JButton("Clear Shell", IconLoader.getImageIcon("application_osx_terminal"));
        this.clearButton.addActionListener(this);
        JPanel clearButtonPanel = new JPanel();
        clearButtonPanel.setLayout(new FlowLayout(2, 5, 1));
        clearButtonPanel.add(this.clearButton);
        this.add((Component)clearButtonPanel, "Last");
        this.initChannel();
        this.initAutoCompletion();
        this.printPrompt();
        this.moveCursorToEnd();
        this.showCursor();
        this.startTimer();
        this.initChannelListener();
        this.initKeyListener();
        this.initPopupMenu();
        this.settings.addListener(this, this.interestedSettings);
    }

    private void initChannel() {
        PipedOutputStream outStream = new PipedOutputStream();
        PipedInputStream inStream = new PipedInputStream();
        this.outWriter = new PrintWriter(outStream);
        try {
            inStream.connect(outStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.channel = this.gui.getEngine().getMessageRouter().openChannel("JamochaGui", inStream);
    }

    private synchronized void printPrompt() {
        this.outputArea.append("Jamocha> ");
        this.lastPromptIndex = this.getOffset();
        this.scrollToCursor();
    }

    private synchronized void printMessage(String message, boolean lineBreak) {
        if (lineBreak) {
            message = message + System.getProperty("line.separator");
        }
        this.outputArea.insert(message, this.cursorPosition);
        this.cursorPosition += message.length();
        if (lineBreak) {
            this.lastPromptIndex = this.getOffset();
        }
    }

    private synchronized void moveCursorToEnd() {
        if (this.cursorPosition != this.getOffset()) {
            this.moveCursorTo(this.getOffset());
        }
    }

    private synchronized void moveCursorTo(int newPosition) {
        this.cursorPosition = newPosition;
    }

    private synchronized void showCursor() {
        if (!this.cursorShowing) {
            int currOffset = this.getOffset();
            if (currOffset >= this.cursorPosition + SHELL_CURSOR.length()) {
                try {
                    this.cursorSubString = this.outputArea.getText(this.cursorPosition, SHELL_CURSOR.length());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.outputArea.replaceRange(SHELL_CURSOR, this.cursorPosition, this.cursorPosition + this.cursorSubString.length());
            } else {
                int offset = currOffset - this.cursorPosition;
                if (offset < 0) {
                    offset = 0;
                }
                try {
                    this.cursorSubString = this.outputArea.getText(this.cursorPosition, offset);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.outputArea.replaceRange(SHELL_CURSOR, this.cursorPosition, this.cursorPosition + offset);
            }
        }
        this.cursorShowing = true;
    }

    private synchronized void hideCursor() {
        if (this.cursorShowing) {
            try {
                this.outputArea.replaceRange(this.cursorSubString, this.cursorPosition, this.cursorPosition + SHELL_CURSOR.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cursorShowing = false;
    }

    private synchronized void removeCharLeft() {
        this.outputArea.replaceRange("", this.cursorPosition - 1, this.cursorPosition);
        --this.cursorPosition;
    }

    private synchronized void removeCharRight() {
        this.outputArea.replaceRange("", this.cursorPosition, this.cursorPosition + 1);
    }

    private synchronized void removeLine() {
        this.outputArea.replaceRange("", this.lastPromptIndex, this.getOffset());
        this.cursorPosition = this.getOffset();
    }

    private synchronized void startTimer() {
        if (!this.cursorTimer.isRunning()) {
            this.cursorTimer.start();
        }
    }

    private synchronized void stopTimer() {
        this.cursorTimer.stop();
    }

    private void initChannelListener() {
        this.gui.getEngine().getMessageRouter().setDefaultChannel(this.channel);
        this.channelListener = new Thread("Shell Panel Channel Listener"){

            public void run() {
                ArrayList<MessageEvent> msgEvents = new ArrayList<MessageEvent>();
                boolean printPrompt = false;
                while (ShellPanel.this.running) {
                    if (!ShellPanel.this.channelListenerPaused) {
                        ShellPanel.this.channel.fillEventList(msgEvents);
                        if (!msgEvents.isEmpty()) {
                            ShellPanel.this.stopTimer();
                            StringBuilder buffer = new StringBuilder();
                            for (MessageEvent event : msgEvents) {
                                if (event.getType() == MessageEvent.MessageEventType.PARSE_ERROR || event.getType() == MessageEvent.MessageEventType.ERROR || event.getType() == MessageEvent.MessageEventType.RESULT) {
                                    printPrompt = true;
                                    ShellPanel.this.lastIncompleteCommand = new StringBuilder();
                                }
                                if (event.getType() == MessageEvent.MessageEventType.ERROR) {
                                    String msg = ((Exception)event.getMessage()).getMessage();
                                    if (msg == null) {
                                        msg = "An unknown error occured. Please check the Log.";
                                    }
                                    buffer.append(msg.trim() + System.getProperty("line.separator"));
                                }
                                if (event.getType() == MessageEvent.MessageEventType.COMMAND || event.getMessage() == null || event.getMessage().toString().equals("") || event.getMessage().equals(JamochaValue.NIL)) continue;
                                buffer.append(event.getMessage().toString().trim() + System.getProperty("line.separator"));
                            }
                            msgEvents.clear();
                            ShellPanel.this.hideCursor();
                            ShellPanel.this.printMessage(buffer.toString().trim(), true);
                            if (printPrompt) {
                                ShellPanel.this.printPrompt();
                                ShellPanel.this.moveCursorTo(ShellPanel.this.lastPromptIndex);
                            }
                            ShellPanel.this.showCursor();
                            printPrompt = false;
                            ShellPanel.this.startTimer();
                            continue;
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    ShellPanel.this.outWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ShellPanel.this.gui.getEngine().getMessageRouter().closeChannel(ShellPanel.this.channel);
            }
        };
        this.channelListener.start();
    }

    private void initKeyListener() {
        KeyAdapter adapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ShellPanel.this.keyEventQueue.offer(e);
                e.consume();
            }
        };
        this.addKeyListener(adapter);
        this.outputArea.addKeyListener(adapter);
        Thread eventThread = new Thread("Shell Panel Key Listener"){

            public void run() {
                while (ShellPanel.this.running) {
                    if (!ShellPanel.this.keyEventQueue.isEmpty()) {
                        KeyEvent e = (KeyEvent)ShellPanel.this.keyEventQueue.poll();
                        int delta = 1;
                        ShellPanel.this.stopTimer();
                        ShellPanel.this.hideCursor();
                        switch (e.getKeyCode()) {
                            case 40: 
                            case 225: {
                                if (ShellPanel.this.autoCompletionBox.isVisible()) {
                                    ShellPanel.this.autoCompletionBox.down();
                                    break;
                                }
                                delta = -1;
                            }
                            case 38: 
                            case 224: {
                                if (ShellPanel.this.autoCompletionBox.isVisible()) {
                                    ShellPanel.this.autoCompletionBox.up();
                                    break;
                                }
                                int old_offset = ShellPanel.this.history_offset;
                                ShellPanel.this.history_offset += delta;
                                if (ShellPanel.this.history_offset <= 0) {
                                    ShellPanel.this.history_offset = 0;
                                    if (ShellPanel.this.lastPromptIndex < ShellPanel.this.getOffset()) {
                                        ShellPanel.this.removeLine();
                                    }
                                    ShellPanel.this.printMessage(ShellPanel.this.history_activeline, false);
                                } else {
                                    int index;
                                    if (ShellPanel.this.history_offset > ShellPanel.this.history.size()) {
                                        ShellPanel.this.history_offset = ShellPanel.this.history.size();
                                    }
                                    if (delta == 1 && old_offset < 1) {
                                        String currLine = "";
                                        try {
                                            currLine = ShellPanel.this.outputArea.getText(ShellPanel.this.lastPromptIndex, ShellPanel.this.getOffset() - ShellPanel.this.lastPromptIndex);
                                        }
                                        catch (BadLocationException e1) {
                                            e1.printStackTrace();
                                        }
                                        ShellPanel.this.history_activeline = currLine;
                                    }
                                    if (ShellPanel.this.lastPromptIndex < ShellPanel.this.getOffset() && ShellPanel.this.history.size() > 0) {
                                        ShellPanel.this.removeLine();
                                    }
                                    if ((index = ShellPanel.this.history.size() - ShellPanel.this.history_offset) >= 0 && ShellPanel.this.history.size() > 0) {
                                        String tmp = (String)ShellPanel.this.history.get(index);
                                        ShellPanel.this.printMessage(tmp, false);
                                    }
                                }
                                ShellPanel.this.moveCursorToEnd();
                                ShellPanel.this.scrollToCursor();
                                break;
                            }
                            case 10: {
                                if (ShellPanel.this.autoCompletionBox.isVisible()) {
                                    ShellPanel.this.autoCompletionBox.keyPressed(e);
                                    break;
                                }
                                ShellPanel.this.moveCursorToEnd();
                                if (ShellPanel.this.lastPromptIndex < ShellPanel.this.getOffset()) {
                                    String currLine = "";
                                    try {
                                        try {
                                            currLine = ShellPanel.this.outputArea.getText(ShellPanel.this.lastPromptIndex, ShellPanel.this.getOffset() - ShellPanel.this.lastPromptIndex);
                                        }
                                        catch (BadLocationException e1) {
                                            e1.printStackTrace();
                                        }
                                        ShellPanel.this.lastIncompleteCommand.append(currLine + System.getProperty("line.separator"));
                                        if (currLine.length() > 0) {
                                            ShellPanel.this.addToHistory(currLine);
                                            ShellPanel.this.outWriter.write(currLine);
                                            ShellPanel.this.outWriter.flush();
                                        }
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                ShellPanel.this.history_activeline = "";
                                ShellPanel.this.printMessage("", true);
                                ShellPanel.this.moveCursorToEnd();
                                ShellPanel.this.scrollToCursor();
                                break;
                            }
                            case 8: {
                                if (ShellPanel.this.cursorPosition > ShellPanel.this.lastPromptIndex) {
                                    ShellPanel.this.removeCharLeft();
                                }
                                ShellPanel.this.scrollToCursor();
                                break;
                            }
                            case 127: {
                                if (ShellPanel.this.cursorPosition < ShellPanel.this.getOffset()) {
                                    ShellPanel.this.removeCharRight();
                                }
                                ShellPanel.this.scrollToCursor();
                                break;
                            }
                            case 39: 
                            case 227: {
                                if (e.isShiftDown()) break;
                                if (ShellPanel.this.cursorPosition < ShellPanel.this.getOffset()) {
                                    ShellPanel.this.moveCursorTo(ShellPanel.this.cursorPosition + 1);
                                }
                                ShellPanel.this.scrollToCursor();
                                break;
                            }
                            case 37: 
                            case 226: {
                                if (e.isShiftDown()) break;
                                if (ShellPanel.this.cursorPosition > ShellPanel.this.lastPromptIndex) {
                                    ShellPanel.this.moveCursorTo(ShellPanel.this.cursorPosition - 1);
                                }
                                ShellPanel.this.scrollToCursor();
                                break;
                            }
                            case 9: {
                                ShellPanel.this.handleFindPath();
                                break;
                            }
                            case 16: 
                            case 17: 
                            case 18: 
                            case 157: {
                                break;
                            }
                            default: {
                                if (!e.isControlDown() && !e.isMetaDown()) {
                                    ShellPanel.this.printMessage(String.valueOf(e.getKeyChar()), false);
                                    ShellPanel.this.scrollToCursor();
                                    break;
                                }
                                if (e.getKeyChar() == 'v' || e.getKeyCode() == 86) {
                                    String clipContent = ClipboardUtil.getInstance().getClipboardContents();
                                    if (clipContent == null) break;
                                    ShellPanel.this.printMessage(clipContent, false);
                                    ShellPanel.this.scrollToCursor();
                                    break;
                                }
                                if (e.getKeyChar() != 'c' && e.getKeyCode() != 67) break;
                                ClipboardUtil.getInstance().setClipboardContents(ShellPanel.this.outputArea.getSelectedText());
                            }
                        }
                        ShellPanel.this.showCursor();
                        ShellPanel.this.handleAutoCompletion();
                        ShellPanel.this.startTimer();
                        continue;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        eventThread.start();
    }

    protected void handleAutoCompletion() {
        if (!this.enableAutoCompletion) {
            return;
        }
        int i = 0;
        Vector<String> suggestions = null;
        try {
            while (this.outputArea.getText().charAt(this.cursorPosition - i) != '(' && this.outputArea.getText().charAt(this.cursorPosition - i) != ' ') {
                ++i;
            }
            if (this.outputArea.getText().charAt(this.cursorPosition - i) == '(') {
                this.autoCompletionPrefix = this.outputArea.getText(this.cursorPosition - i + 1, i - 1);
                suggestions = this.autoCompletion.getAllBeginningWith(this.autoCompletionPrefix);
            } else {
                suggestions = new Vector();
            }
        }
        catch (Exception e) {
            suggestions = new Vector<String>();
        }
        if (!suggestions.isEmpty()) {
            Caret c = this.outputArea.getCaret();
            DefaultCaret bc = (DefaultCaret)c;
            int x = bc.x + this.outputArea.getLocationOnScreen().x;
            int y = bc.y + bc.height + this.outputArea.getLocationOnScreen().y;
            this.autoCompletionBox.show(suggestions, x, y);
        } else {
            this.autoCompletionBox.hide();
        }
    }

    protected void handleFindPath() {
        String currLine = "";
        try {
            currLine = this.outputArea.getText(this.lastPromptIndex, this.getOffset() - this.lastPromptIndex);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        int offset = currLine.lastIndexOf(" ") + 1;
        currLine = currLine.substring(offset);
        offset = currLine.lastIndexOf(File.separator) + 1;
        File path = new File("." + File.separator);
        String remainder = currLine.substring(offset, currLine.length());
        if (remainder.length() > 0) {
            File[] children;
            if (offset > 0) {
                path = new File(currLine.substring(0, offset));
            }
            if ((children = path.listFiles()) != null) {
                for (File child : children) {
                    String childName = child.getName();
                    if (!childName.startsWith(remainder)) continue;
                    if (child.isDirectory()) {
                        childName = childName + File.separator;
                    }
                    this.printMessage(childName.substring(remainder.length()), false);
                    this.scrollToCursor();
                    return;
                }
            }
        }
    }

    void scrollToCursor() {
        this.outputArea.setCaretPosition(this.cursorPosition);
    }

    private void addToHistory(String historyString) {
        String[] lines = historyString.split(System.getProperty("line.separator"));
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].equals("")) continue;
            this.history.add(lines[i]);
        }
        while (this.history.size() > 100) {
            this.history.remove(0);
        }
        this.history_offset = 0;
    }

    private void initPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem copyMenu = new JMenuItem("Copy", IconLoader.getImageIcon("page_copy"));
        copyMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ClipboardUtil.getInstance().setClipboardContents(ShellPanel.this.outputArea.getSelectedText());
            }
        });
        JMenuItem pasteMenu = new JMenuItem("Paste", IconLoader.getImageIcon("paste_plain"));
        pasteMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                String clipContent = ClipboardUtil.getInstance().getClipboardContents();
                if (clipContent != null) {
                    ShellPanel.this.printMessage(clipContent, false);
                }
            }
        });
        JMenuItem selectCommandMenu = new JMenuItem("Select current line");
        selectCommandMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ShellPanel.this.outputArea.setSelectionStart(ShellPanel.this.lastPromptIndex);
                ShellPanel.this.outputArea.setSelectionEnd(ShellPanel.this.getOffset());
            }
        });
        JMenuItem selectAllMenu = new JMenuItem("Select all");
        selectAllMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ShellPanel.this.outputArea.setSelectionStart(0);
                ShellPanel.this.outputArea.setSelectionEnd(ShellPanel.this.getOffset());
            }
        });
        JMenuItem clearLineMenu = new JMenuItem("Clear Line");
        clearLineMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ShellPanel.this.removeLine();
            }
        });
        JMenuItem clearShellMenu = new JMenuItem("Clear Shell");
        clearShellMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ShellPanel.this.clearArea();
            }
        });
        JMenuItem resetShellMenu = new JMenuItem("Reset Shell");
        resetShellMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ShellPanel.this.stopTimer();
                ShellPanel.this.hideCursor();
                ShellPanel.this.channelListenerPaused = true;
                ShellPanel.this.lastIncompleteCommand = new StringBuilder();
                ShellPanel.this.clearArea();
                ShellPanel.this.gui.getEngine().getMessageRouter().closeChannel(ShellPanel.this.channel);
                ShellPanel.this.initChannel();
                ShellPanel.this.channelListenerPaused = false;
                ShellPanel.this.showCursor();
                ShellPanel.this.startTimer();
            }
        });
        menu.add(copyMenu);
        menu.add(pasteMenu);
        menu.addSeparator();
        menu.add(selectCommandMenu);
        menu.add(selectAllMenu);
        menu.addSeparator();
        menu.add(clearLineMenu);
        menu.add(clearShellMenu);
        menu.addSeparator();
        menu.add(resetShellMenu);
        this.outputArea.setComponentPopupMenu(menu);
    }

    private synchronized void clearArea() {
        this.stopTimer();
        this.hideCursor();
        this.outputArea.setText("");
        this.lastPromptIndex = 0;
        this.cursorPosition = 0;
        this.lastScrollBarPosition = 0;
        if (this.lastIncompleteCommand.length() > 0) {
            this.printPrompt();
            this.cursorPosition = this.getOffset();
            this.printMessage(this.lastIncompleteCommand.toString().trim(), true);
        } else {
            this.printPrompt();
        }
        this.moveCursorToEnd();
        this.setFocus();
        this.showCursor();
        this.startTimer();
    }

    private synchronized int getOffset() {
        try {
            return this.outputArea.getLineEndOffset(this.outputArea.getLineCount() - 1);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public void setFocus() {
        super.setFocus();
    }

    public void close() {
        this.stopTimer();
        this.running = false;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.clearButton)) {
            this.clearArea();
        } else if (event.getSource().equals(this.cursorTimer)) {
            if (this.cursorShowing) {
                this.hideCursor();
            } else {
                this.showCursor();
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        if (event.getValue() < this.lastScrollBarPosition) {
            this.stopTimer();
        } else {
            this.lastScrollBarPosition = event.getValue();
            this.startTimer();
        }
    }

    public void settingsChanged(String propertyName) {
        if (propertyName.startsWith("gui.shell.font")) {
            this.outputArea.setFont(new Font(this.settings.getString("gui.shell.font"), this.settings.getInt("gui.shell.fontstyle"), this.settings.getInt("gui.shell.fontsize")));
            this.outputArea.setForeground(new Color(this.settings.getInt("gui.shell.fontcolor")));
        } else if (propertyName.equals("gui.shell.backgroundcolor")) {
            this.outputArea.setBackground(new Color(this.settings.getInt("gui.shell.backgroundcolor")));
            this.outputArea.setBorder(BorderFactory.createLineBorder(this.outputArea.getBackground(), 2));
        } else if (propertyName.equals("gui.shell.autocompletion")) {
            this.enableAutoCompletion = this.settings.getBoolean("gui.shell.autocompletion");
        }
    }

    public String getAutoCompletionPrefix() {
        return this.autoCompletionPrefix;
    }

    public JTextArea getOutputArea() {
        return this.outputArea;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }
}

