/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.TableModelQuickSort;
import org.jamocha.application.gui.TableRowModel;
import org.jamocha.application.gui.editor.RuleEditor;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.engine.modules.Module;
import org.jamocha.parser.ParserFactory;
import org.jamocha.rules.Rule;

public class RulesPanel
extends AbstractJamochaPanel
implements ActionListener,
ListSelectionListener {
    private static final String GUI_RULES_DIVIDERLOCATION = "gui.rules.dividerlocation";
    private static final long serialVersionUID = -5732131176258158968L;
    private final JSplitPane pane;
    private final JTable rulesTable;
    private final RulesTableModel dataModel;
    private final JButton reloadButton;
    private final JButton addRuleButton;
    private final JTextArea dumpArea;

    public RulesPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.dataModel = new RulesTableModel();
        this.rulesTable = new JTable(this.dataModel);
        this.rulesTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = RulesPanel.this.rulesTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = RulesPanel.this.rulesTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    TableModelQuickSort.sort(RulesPanel.this.dataModel, ascending, column);
                }
            }
        });
        this.rulesTable.setShowHorizontalLines(true);
        this.rulesTable.setRowSelectionAllowed(true);
        this.rulesTable.getTableHeader().setReorderingAllowed(false);
        this.rulesTable.getTableHeader().setToolTipText("Click to sort ascending. Click while pressing the shift-key down to sort descending");
        this.rulesTable.getSelectionModel().addListSelectionListener(this);
        this.dumpArea = new JTextArea();
        this.dumpArea.setLineWrap(true);
        this.dumpArea.setWrapStyleWord(true);
        this.dumpArea.setEditable(false);
        this.dumpArea.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, new JScrollPane(this.rulesTable), new JScrollPane(this.dumpArea));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(this.settings.getInt(GUI_RULES_DIVIDERLOCATION));
        this.reloadButton = new JButton("Reload Rules", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        this.addRuleButton = new JButton("Add new Rule", IconLoader.getImageIcon("car_add"));
        this.addRuleButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        buttonPanel.add(this.addRuleButton);
        this.add((Component)buttonPanel, "Last");
        this.initPopupMenu();
        this.initRulesList();
    }

    private void initRulesList() {
        this.dataModel.clear();
        Collection<Module> modules = this.gui.getEngine().getModules().getModuleList();
        for (Module module : modules) {
            List<Rule> rules = module.getAllRules();
            this.dataModel.addRules(rules);
        }
        this.rulesTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.rulesTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.rulesTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.rulesTable.getColumnModel().getColumn(3).setPreferredWidth(this.rulesTable.getWidth() - 350);
    }

    private void initPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem retractItem = new JMenuItem("Delete selected Rule(s)", IconLoader.getImageIcon("car_delete"));
        retractItem.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                int[] selCols = RulesPanel.this.rulesTable.getSelectedRows();
                for (int i = 0; i < selCols.length; ++i) {
                    Rule rule = (Rule)RulesPanel.this.dataModel.getRowAt(selCols[i]);
                    if (rule == null) continue;
                    RulesPanel.this.gui.getEngine().removeRule(rule);
                }
                RulesPanel.this.initRulesList();
            }
        });
        menu.add(retractItem);
        this.rulesTable.setComponentPopupMenu(menu);
    }

    public void setFocus() {
        super.setFocus();
        this.initRulesList();
    }

    public void close() {
        this.settings.set(GUI_RULES_DIVIDERLOCATION, this.pane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initRulesList();
        } else if (event.getSource().equals(this.addRuleButton)) {
            RuleEditor editor = new RuleEditor(this.gui.getEngine());
            editor.setStringChannel(this.gui.getStringChannel());
            editor.init();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.rulesTable.getSelectionModel()) {
            Rule rule;
            StringBuilder buffer = new StringBuilder();
            if (this.rulesTable.getSelectedColumnCount() == 1 && this.rulesTable.getSelectedRow() > -1 && (rule = (Rule)this.dataModel.getRowAt(this.rulesTable.getSelectedRow())) != null) {
                buffer.append(ParserFactory.getFormatter(true).visit(rule));
            }
            this.dumpArea.setText(buffer.toString());
            this.dumpArea.setCaretPosition(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RulesTableModel
    extends AbstractTableModel
    implements TableRowModel {
        private static final long serialVersionUID = 1L;
        private List<Rule> rules = Collections.emptyList();

        private RulesTableModel() {
        }

        private void clear() {
            this.rules = new LinkedList<Rule>();
            this.fireTableDataChanged();
        }

        private void addRules(Collection<Rule> rules) {
            for (Rule rule : rules) {
                this.rules.add(rule);
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Module";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Complexity";
                }
                case 3: {
                    return "Comment";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class getColumnClass(int aColumn) {
            if (aColumn == 2) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.rules.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Rule rule = (Rule)this.getRowAt(row);
            switch (column) {
                case 0: {
                    return rule.parentModule().getName();
                }
                case 1: {
                    return rule.getName();
                }
                case 2: {
                    return rule.getComplexity();
                }
                case 3: {
                    return rule.getDescription();
                }
            }
            return null;
        }

        @Override
        public Object getRowAt(int row) {
            return this.rules.get(row);
        }

        @Override
        public void setRowAt(Object value, int row) {
            this.rules.set(row, (Rule)value);
        }
    }
}

