/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.InterestType;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.parser.Expression;
import org.jamocha.parser.ParserFactory;

public class LogPanel
extends AbstractJamochaPanel
implements ActionListener,
ListSelectionListener {
    private static final String GUI_LOG_DIVIDERLOCATION = "gui.log.dividerlocation";
    private static final long serialVersionUID = 4811690181744862051L;
    private final JSplitPane pane;
    private final JTextArea detailView;
    private final JTable logTable;
    private final JButton clearButton;
    private final LogTableModel dataModel = new LogTableModel();
    private final LogTableCellRenderer cellRenderer;
    private final StringChannel logChannel;
    private boolean running = true;

    public LogPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.logChannel = gui.getEngine().getMessageRouter().openChannel("gui_log", InterestType.ALL);
        this.detailView = new JTextArea();
        this.detailView.setEditable(false);
        this.detailView.setFont(new Font("Courier", 0, 12));
        this.cellRenderer = new LogTableCellRenderer();
        this.logTable = new JTable(this.dataModel){
            private static final long serialVersionUID = 1L;

            public TableCellRenderer getCellRenderer(int row, int column) {
                return LogPanel.this.cellRenderer;
            }
        };
        this.logTable.setSelectionMode(0);
        this.logTable.getSelectionModel().addListSelectionListener(this);
        this.pane = new JSplitPane(0, new JScrollPane(this.logTable), new JScrollPane(this.detailView));
        this.pane.setDividerLocation(this.settings.getInt(GUI_LOG_DIVIDERLOCATION));
        this.add((Component)this.pane, "Center");
        Thread logThread = new Thread("GUI Log"){

            public void run() {
                LinkedList<MessageEvent> msgEvents = new LinkedList<MessageEvent>();
                while (LogPanel.this.running) {
                    LogPanel.this.logChannel.fillEventList(msgEvents);
                    if (!msgEvents.isEmpty()) {
                        LogPanel.this.dataModel.addEvents(msgEvents);
                        msgEvents.clear();
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LogPanel.this.gui.getEngine().getMessageRouter().closeChannel(LogPanel.this.logChannel);
            }
        };
        logThread.start();
        this.clearButton = new JButton("Clear Log", IconLoader.getImageIcon("monitor"));
        this.clearButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.clearButton);
        this.add((Component)buttonPanel, "Last");
    }

    public void close() {
        this.running = false;
        this.settings.set(GUI_LOG_DIVIDERLOCATION, this.pane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.clearButton) {
            this.dataModel.clearEvents();
            this.detailView.setText("");
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.logTable.getSelectionModel()) {
            StringBuilder buffer = new StringBuilder();
            if (this.logTable.getSelectedRow() > -1) {
                LogMessageEvent event = this.dataModel.getRow(this.logTable.getSelectedRow());
                buffer.append("Date-Time:    " + event.getDatetimeFormatted() + "\nChannel:      " + event.getChannelId() + "\nMessage-Type: " + event.getTypeFormatted() + "\n\nMessage:\n========\n");
                Object message = event.getMessage();
                if (message instanceof Exception) {
                    Throwable ex = (Throwable)message;
                    buffer.append("List of Exception messages:\n");
                    while (ex.getCause() != null) {
                        if (ex.getMessage() != null) {
                            buffer.append("\n- ").append(ex.getMessage());
                        }
                        ex = ex.getCause();
                    }
                    buffer.append("\n- ").append(ex.getMessage());
                    buffer.append("\n\nStacktrace of innermost cause:\n\n");
                    StackTraceElement[] str = ex.getStackTrace();
                    buffer.append(ex.getClass().getName()).append("\n");
                    for (StackTraceElement strelem : str) {
                        buffer.append("\n").append(strelem);
                    }
                } else if (message instanceof Expression) {
                    buffer.append(((Expression)message).format(ParserFactory.getFormatter(true)));
                } else if (message != null) {
                    buffer.append(message.toString());
                }
            }
            this.detailView.setText(buffer.toString());
            this.detailView.setCaretPosition(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LogTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final List<LogMessageEvent> events = new LinkedList<LogMessageEvent>();
        private final int maxEventCount = 1000;

        private LogTableModel() {
        }

        private void addEvents(List<MessageEvent> events) {
            LogPanel.this.logTable.getColumnModel().getColumn(0).setPreferredWidth(180);
            LogPanel.this.logTable.getColumnModel().getColumn(1).setPreferredWidth(180);
            LogPanel.this.logTable.getColumnModel().getColumn(2).setPreferredWidth(LogPanel.this.logTable.getWidth() - 360);
            for (MessageEvent event : events) {
                this.events.add(new LogMessageEvent(event));
            }
            while (this.events.size() > 1000) {
                this.events.remove(0);
            }
            this.fireTableDataChanged();
        }

        private void clearEvents() {
            this.events.clear();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Date - Time";
                }
                case 1: {
                    return "Channel";
                }
                case 2: {
                    return "Message-Type";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int aColumn) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.events.size();
        }

        public LogMessageEvent getRow(int row) {
            return this.events.get(this.events.size() - (row + 1));
        }

        @Override
        public Object getValueAt(int row, int column) {
            LogMessageEvent event = this.getRow(row);
            if (event != null) {
                switch (column) {
                    case 0: {
                        return event.getDatetimeFormatted();
                    }
                    case 1: {
                        return event.getChannelId();
                    }
                    case 2: {
                        return event.getTypeFormatted();
                    }
                }
            }
            return null;
        }
    }

    private final class LogTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -6649805279420707106L;
        private final Color colorError = Color.RED;
        private final Color colorWarning = Color.ORANGE;
        private final Color colorEvent = Color.BLUE;

        private LogTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent returnComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            switch (((LogTableModel)table.getModel()).getRow(row).getSuperType()) {
                case 3: {
                    this.setForeground(this.colorError);
                    break;
                }
                case 2: {
                    this.setForeground(this.colorWarning);
                    break;
                }
                default: {
                    this.setForeground(this.colorEvent);
                }
            }
            return returnComponent;
        }
    }

    private final class LogMessageEvent
    extends MessageEvent {
        private static final long serialVersionUID = -5690784906495393031L;
        private final Calendar datetime;
        private String typeFormatted;
        private int superType;
        public static final int TYPE_EVENT = 1;
        public static final int TYPE_WARNING = 2;
        public static final int TYPE_ERROR = 3;

        public LogMessageEvent(MessageEvent event) {
            this(event.getType(), event.getMessage(), event.getChannelId());
        }

        public LogMessageEvent(MessageEvent.MessageEventType type, Object message, String channelId) {
            super(type, message, channelId);
            this.datetime = Calendar.getInstance();
            switch (type) {
                case COMMAND: {
                    this.typeFormatted = "EVENT: incoming Command";
                    this.superType = 1;
                    break;
                }
                case ENGINE: {
                    this.typeFormatted = "EVENT: Engine-Message";
                    this.superType = 1;
                    break;
                }
                case ERROR: {
                    this.typeFormatted = "ERROR: unspecified Error";
                    this.superType = 3;
                    break;
                }
                case PARSE_ERROR: {
                    this.typeFormatted = "ERROR: Parse-Error";
                    this.superType = 3;
                    break;
                }
                case RESULT: {
                    this.typeFormatted = "EVENT: returned result";
                    this.superType = 1;
                    break;
                }
                default: {
                    this.typeFormatted = "Unknown Messagetype";
                    this.superType = 1;
                }
            }
        }

        public int getSuperType() {
            return this.superType;
        }

        public String getDatetimeFormatted() {
            StringBuilder res = new StringBuilder();
            res.append(this.datetime.get(1) + "/");
            res.append((this.datetime.get(2) + 1 > 9 ? "" : "0") + (this.datetime.get(2) + 1) + "/");
            res.append((this.datetime.get(5) > 9 ? "" : "0") + this.datetime.get(5) + " - ");
            res.append((this.datetime.get(11) > 9 ? "" : "0") + this.datetime.get(11) + ":");
            res.append((this.datetime.get(12) > 9 ? "" : "0") + this.datetime.get(12) + ":");
            res.append((this.datetime.get(13) > 9 ? "" : "0") + this.datetime.get(13));
            return res.toString();
        }

        public String getTypeFormatted() {
            return this.typeFormatted;
        }
    }
}

