/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.jamocha.application.gui.tab.AutoCompletion;
import org.jamocha.application.gui.tab.ShellPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionBox
implements KeyListener,
MouseListener {
    JScrollPane list;
    ShellPanel panel;
    JList alist;
    JFrame parent;
    Popup listFrame = null;
    boolean visible = false;
    int numElems = 0;
    Vector<String> strings = null;
    AutoCompletion ac;
    PopupFactory factory;

    public AutoCompletionBox(JFrame parent, AutoCompletion ac, ShellPanel panel) {
        this.parent = parent;
        this.panel = panel;
        this.factory = PopupFactory.getSharedInstance();
        this.alist = new JList();
        this.list = new JScrollPane(this.alist);
        this.alist.setMinimumSize(new Dimension(70, 1));
        this.alist.setMaximumSize(new Dimension(1000, 100));
        this.alist.addKeyListener(this);
        this.alist.addMouseListener(this);
        this.ac = ac;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void up() {
        int now = this.alist.getSelectedIndex();
        if (--now < 0) {
            now = this.strings.size() - 1;
        }
        this.alist.setSelectedIndex(now);
    }

    public void down() {
        int now = this.alist.getSelectedIndex();
        if (++now >= this.strings.size()) {
            now = 0;
        }
        this.alist.setSelectedIndex(now);
    }

    public void hide() {
        this.visible = false;
        if (this.listFrame != null) {
            this.listFrame.hide();
        }
    }

    public String getSelected(boolean full) {
        String s = (String)this.alist.getSelectedValue();
        if (!full) {
            return s;
        }
        return this.ac.getFullText(s);
    }

    public void show(Vector<String> lst, int x, int y) {
        if (this.visible && this.numElems == lst.size()) {
            return;
        }
        this.numElems = lst.size();
        this.visible = true;
        this.strings = lst;
        this.alist.setListData(lst);
        this.alist.setSelectedIndex(0);
        if (this.listFrame != null) {
            this.listFrame.hide();
        }
        this.listFrame = this.factory.getPopup(this.parent, this.list, x, y);
        this.listFrame.show();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean full = (e.getModifiers() & 2) != 0;
        String autoCompletionPrefix = this.panel.getAutoCompletionPrefix();
        JTextArea outputArea = this.panel.getOutputArea();
        if (full) {
            this.fullInsertion(autoCompletionPrefix, outputArea);
        } else {
            this.normalInsertion(autoCompletionPrefix, outputArea);
        }
        this.panel.scrollToCursor();
        this.hide();
        outputArea.requestFocus();
    }

    private void normalInsertion(String autoCompletionPrefix, JTextArea outputArea) {
        String txt = this.getSelected(false).substring(autoCompletionPrefix.length());
        int cursorPos = outputArea.getCaretPosition();
        outputArea.insert(txt + " ", cursorPos);
        this.panel.setCursorPosition(cursorPos + txt.length() + 1);
    }

    private void fullInsertion(String autoCompletionPrefix, JTextArea outputArea) {
        String txt = this.getSelected(true).substring(autoCompletionPrefix.length());
        String shorttxt = this.getSelected(false).substring(autoCompletionPrefix.length());
        int cursorPos = outputArea.getCaretPosition();
        outputArea.insert(txt, cursorPos);
        this.panel.setCursorPosition(cursorPos + shorttxt.length() + 1);
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getClickCount() > 1) {
            this.normalInsertion(this.panel.getAutoCompletionPrefix(), this.panel.getOutputArea());
            this.panel.scrollToCursor();
            this.hide();
            this.panel.getOutputArea().requestFocus();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

