/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletion {
    protected final int cacheSize = 20;
    protected Map<String, String> fullText;
    protected Vector<String> tokens = new Vector();
    protected Vector<String>[] cache;
    protected String[] cachePrefixes;
    protected int[] useCounter;

    public AutoCompletion() {
        this.fullText = new HashMap<String, String>();
        this.cache = new Vector[20];
        this.cachePrefixes = new String[20];
        this.useCounter = new int[20];
        for (int i = 0; i < 20; ++i) {
            this.useCounter[i] = 0;
        }
    }

    public void addToken(String token, String fullText) {
        this.addToken(token);
        this.fullText.put(token, fullText);
    }

    public void addToken(String token) {
        int i;
        for (i = 0; i < this.tokens.size() && token.compareTo(this.tokens.get(i)) >= 0; ++i) {
        }
        this.tokens.add(i, token);
    }

    protected Vector<String> getAllBeginningWith(List<String> s, String prefix) {
        Vector<String> result = new Vector<String>();
        for (String str : s) {
            if (!str.startsWith(prefix)) continue;
            result.add(str);
        }
        return result;
    }

    public String getFullText(String token) {
        String res = this.fullText.get(token);
        if (res == null) {
            return token;
        }
        return res;
    }

    public Vector<String> getAllBeginningWith(String prefix) {
        int found = -1;
        String pf = prefix;
        Vector<String> weUseList = null;
        while (found < 0 && pf.length() > 0) {
            for (int i = 0; i < 20; ++i) {
                if (this.cachePrefixes[i] == null || !this.cachePrefixes[i].equals(pf)) continue;
                found = i;
                break;
            }
            pf = pf.substring(0, pf.length() - 1);
        }
        if (found > 0) {
            int n = found;
            this.useCounter[n] = this.useCounter[n] + 1;
            weUseList = this.cache[found];
        } else {
            weUseList = this.tokens;
        }
        Vector<String> result = this.getAllBeginningWith(weUseList, prefix);
        int minuse = Integer.MAX_VALUE;
        int minuseindex = -1;
        for (int i = 0; i < 20; ++i) {
            if (this.useCounter[i] >= minuse) continue;
            minuse = this.useCounter[i];
            minuseindex = i;
        }
        this.cache[minuseindex] = result;
        this.cachePrefixes[minuseindex] = prefix;
        this.useCounter[minuseindex] = 1;
        return result;
    }
}

