/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.retevisualisation.nodedrawers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.List;
import org.jamocha.application.gui.retevisualisation.VisualizerSetup;
import org.jamocha.application.gui.retevisualisation.nodedrawers.AbstractNodeDrawer;
import org.jamocha.engine.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNodeDrawer
extends AbstractNodeDrawer {
    public RootNodeDrawer(Node owner) {
        super(owner);
    }

    @Override
    protected void drawNode(int x, int y, int height, int width, int halfLineHeight, List<Node> selected, Graphics2D canvas) {
        int alpha = selected.contains(this.node) ? 255 : 20;
        canvas.setBackground(new Color(0, 0, 0, alpha));
        canvas.setColor(new Color(40, 40, 40, alpha));
        canvas.fillOval(x, y, width, height);
        canvas.drawOval(x, y, width, height);
        canvas.setColor(new Color(255, 255, 255, alpha));
        this.drawId(x, y, height, width, halfLineHeight, canvas);
    }

    @Override
    public Point getLineEndPoint(Point target, Point me, VisualizerSetup setup) {
        double angle = RootNodeDrawer.atan3(-target.y + me.y, target.x - me.x);
        double unitCircleX = Math.cos(angle);
        double unitCircleY = Math.sin(angle);
        Point result = new Point();
        result.x = (int)(unitCircleX * 64.0 * (double)setup.scaleX / 2.0 + (double)me.x);
        result.y = (int)(-unitCircleY * 24.0 * (double)setup.scaleY / 2.0 + (double)me.y);
        return result;
    }
}

