/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.retevisualisation.nodedrawers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.List;
import org.jamocha.application.gui.retevisualisation.VisualizerSetup;
import org.jamocha.application.gui.retevisualisation.nodedrawers.AbstractNodeDrawer;
import org.jamocha.engine.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIANodeDrawer
extends AbstractNodeDrawer {
    protected static Point bottomLeft = new Point(-22, -12);
    protected static Point bottomRight = new Point(22, -12);
    protected static Point topLeft = new Point(-32, 12);
    protected static Point topRight = new Point(32, 12);
    protected static double angleTopLeft = RIANodeDrawer.atan3(RIANodeDrawer.topLeft.y, RIANodeDrawer.topLeft.x);
    protected static double angleTopRight = RIANodeDrawer.atan3(RIANodeDrawer.topRight.y, RIANodeDrawer.topRight.x);
    protected static double angleBottomLeft = RIANodeDrawer.atan3(RIANodeDrawer.bottomLeft.y, RIANodeDrawer.bottomLeft.x);
    protected static double angleBottomRight = RIANodeDrawer.atan3(RIANodeDrawer.bottomRight.y, RIANodeDrawer.bottomRight.x);

    public RIANodeDrawer(Node owner) {
        super(owner);
    }

    @Override
    protected void drawNode(int x, int y, int height, int width, int halfLineHeight, List<Node> selected, Graphics2D canvas) {
        int alpha = selected.contains(this.node) ? 255 : 20;
        int[] xpoints = new int[]{x, x + width, (int)((double)x + (double)width * 0.8), x + (int)((double)width * 0.2)};
        int[] ypoints = new int[]{y, y, y + height, y + height};
        canvas.setColor(new Color(28, 255, 252, alpha));
        canvas.fillPolygon(xpoints, ypoints, 4);
        canvas.setColor(new Color(107, 197, 196, alpha));
        canvas.drawPolygon(xpoints, ypoints, 4);
        canvas.setColor(new Color(0, 0, 0, alpha));
        this.drawId(x, y, height, width, halfLineHeight, canvas);
    }

    @Override
    public Point getLineEndPoint(Point target, Point me, VisualizerSetup setup) {
        return this.getLineEndPoint2(target, me, setup, angleTopRight, angleTopLeft, angleBottomRight, angleBottomLeft, topRight, topLeft, bottomRight, bottomLeft);
    }
}

