/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.retevisualisation.nodedrawers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;
import javax.swing.ImageIcon;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.retevisualisation.nodedrawers.AbstractNodeDrawer;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.ObjectTypeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeNodeDrawer
extends AbstractNodeDrawer {
    private Image icon = null;

    public ObjectTypeNodeDrawer(Node owner) {
        super(owner);
        ImageIcon ii;
        String templname = ((ObjectTypeNode)owner).getTemplate().getName();
        if (templname.equals("_initialFact")) {
            templname = "initialFact";
        }
        if ((ii = IconLoader.getImageIcon(templname, this.getClass())) != null) {
            while (ii.getImageLoadStatus() == 1) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {}
            }
            this.icon = ii.getImage();
        }
    }

    @Override
    protected void drawNode(int x, int y, int height, int width, int halfLineHeight, List<Node> selected, Graphics2D canvas) {
        boolean isSelected = selected.contains(this.node);
        int alpha = isSelected ? 255 : 20;
        canvas.setColor(new Color(255, 215, 15, alpha));
        canvas.fillRect(x, y, width, height);
        canvas.setColor(new Color(208, 181, 44, alpha));
        canvas.drawRect(x, y, width, height);
        canvas.setColor(new Color(0, 0, 0, alpha));
        this.drawId(x, y, height, width, halfLineHeight, canvas);
        if (this.icon != null && isSelected) {
            float aspectRatio = this.icon.getWidth(null) / this.icon.getHeight(null);
            int w = (int)((float)height * aspectRatio);
            int h = height;
            int x1 = x + width - w / 2;
            int y1 = y;
            canvas.drawImage(this.icon, x1, y1, w, h, null);
        }
    }
}

