/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.retevisualisation.nodedrawers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.application.gui.retevisualisation.VisualizerSetup;
import org.jamocha.engine.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractNodeDrawer
implements NodeDrawer {
    protected Node node;
    public static final int shapeWidth = 64;
    public static final int shapeHeight = 24;
    public static final int shapeGapWidth = 25;
    public static final int shapeGapHeight = 25;
    protected static Point bottomLeft = new Point(-32, -12);
    protected static Point bottomRight = new Point(32, -12);
    protected static Point topLeft = new Point(-32, 12);
    protected static Point topRight = new Point(32, 12);
    protected static double angleTopLeft = AbstractNodeDrawer.atan3(AbstractNodeDrawer.topLeft.y, AbstractNodeDrawer.topLeft.x);
    protected static double angleTopRight = AbstractNodeDrawer.atan3(AbstractNodeDrawer.topRight.y, AbstractNodeDrawer.topRight.x);
    protected static double angleBottomLeft = AbstractNodeDrawer.atan3(AbstractNodeDrawer.bottomLeft.y, AbstractNodeDrawer.bottomLeft.x);
    protected static double angleBottomRight = AbstractNodeDrawer.atan3(AbstractNodeDrawer.bottomRight.y, AbstractNodeDrawer.bottomRight.x);

    public AbstractNodeDrawer(Node owner) {
        this.node = owner;
    }

    protected void drawNode(int x, int y, int height, int width, int halfLineHeight, List<Node> selected, Graphics2D canvas) {
        int alpha = selected.contains(this.node) ? 255 : 20;
        canvas.setColor(new Color(255, 40, 40, alpha));
        canvas.fillRect(x, y, width, height);
        canvas.setColor(new Color(200, 15, 15, alpha));
        canvas.drawRect(x, y, width, height);
        canvas.setColor(new Color(0, 0, 0, alpha));
        this.drawId(x, y, height, width, halfLineHeight, canvas);
    }

    protected void drawId(int x, int y, int height, int width, int halfLineHeight, Graphics2D canvas) {
        if (height < 12) {
            return;
        }
        String text = String.valueOf(this.node.getId());
        int halfLineWidth = canvas.getFontMetrics().stringWidth(text) / 2;
        int paintX = x + width / 2 - halfLineWidth;
        int paintY = y + height / 2 + halfLineHeight;
        canvas.drawString(text, paintX, paintY);
    }

    @Override
    public int drawNode(int fromColumn, List<Node> selected, Graphics2D canvas, VisualizerSetup setup, Map<Node, Point> positions, Map<Point, Node> p2n, Map<Node, Integer> rowHints, int halfLineHeight) {
        int firstColumn = fromColumn;
        Integer row = rowHints.get(this.node);
        if (row == null) {
            row = 0;
        }
        for (Node child : this.node.getChildNodes()) {
            if (child.getParentNodes()[0] != this.node) continue;
            firstColumn += child.getNodeDrawer().drawNode(firstColumn, selected, canvas, setup, positions, p2n, rowHints, halfLineHeight);
        }
        int width = firstColumn - fromColumn;
        if (width == 0) {
            width = 2;
        }
        int column = fromColumn + width / 2 - 1;
        int y = 49 * row + 12;
        int x = 44 * column + 12;
        x += setup.offsetX;
        y += setup.offsetY;
        x = (int)((float)x * setup.scaleX);
        y = (int)((float)y * setup.scaleY);
        int w = 64;
        int h = 24;
        h = (int)((float)h * setup.scaleY);
        w = (int)((float)w * setup.scaleX);
        Point p1 = new Point(column, row);
        Point p2 = new Point(column + 1, row);
        positions.put(this.node, p1);
        p2n.put(p1, this.node);
        p2n.put(p2, this.node);
        this.drawNode(x, y, h, w, halfLineHeight, selected, canvas);
        return width;
    }

    protected static Point intersectionPoint(Point l1p1, Point l1p2, Point l2p1, Point l2p2) {
        Point result = new Point();
        double x1 = l1p1.x;
        double x2 = l1p2.x;
        double x3 = l2p1.x;
        double x4 = l2p2.x;
        double y1 = l1p1.y;
        double y2 = l1p2.y;
        double y3 = l2p1.y;
        double y4 = l2p2.y;
        double denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        double ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denom;
        result.x = (int)(x1 + ua * (x2 - x1));
        result.y = (int)(y1 + ua * (y2 - y1));
        return result;
    }

    public static double atan3(double y, double x) {
        double result = Math.atan2(y, x);
        if (result < 0.0) {
            result += Math.PI * 2;
        }
        return result;
    }

    @Override
    public Point getHorizontalEndPoint(Point target, Point me, VisualizerSetup setup) {
        Point target2 = new Point(target.x, me.y);
        return this.getLineEndPoint(target2, me, setup);
    }

    @Override
    public Point getVerticalEndPoint(Point target, Point me, VisualizerSetup setup) {
        Point target2 = new Point(me.x, target.y);
        return this.getLineEndPoint(target2, me, setup);
    }

    @Override
    public Point getLineEndPoint(Point target, Point me, VisualizerSetup setup) {
        return this.getLineEndPoint2(target, me, setup, angleTopRight, angleTopLeft, angleBottomRight, angleBottomLeft, topRight, topLeft, bottomRight, bottomLeft);
    }

    @Override
    public Point getLineEndPoint2(Point target, Point me, VisualizerSetup setup, double atr, double atl, double abr, double abl, Point ptr, Point ptl, Point pbr, Point pbl) {
        Point p2;
        Point p1;
        double angle = AbstractNodeDrawer.atan3(-target.y + me.y, target.x - me.x);
        if (angle < atr || angle >= abr) {
            p1 = ptr;
            p2 = pbr;
        } else if (angle < atl) {
            p1 = ptl;
            p2 = ptr;
        } else if (angle < abl) {
            p1 = ptl;
            p2 = pbl;
        } else {
            p1 = pbr;
            p2 = pbl;
        }
        Point pp1 = new Point(p1);
        Point pp2 = new Point(p2);
        pp1.x = (int)((float)pp1.x * setup.scaleX);
        pp1.y = (int)((float)pp1.y * setup.scaleY);
        pp2.x = (int)((float)pp2.x * setup.scaleX);
        pp2.y = (int)((float)pp2.y * setup.scaleY);
        pp1.x += me.x;
        pp1.y = me.y - pp1.y;
        pp2.x += me.x;
        pp2.y = me.y - pp2.y;
        return AbstractNodeDrawer.intersectionPoint(pp1, pp2, target, me);
    }
}

