/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.retevisualisation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import org.jamocha.application.gui.retevisualisation.ClickListener;
import org.jamocha.application.gui.retevisualisation.ViewportChangeEvent;
import org.jamocha.application.gui.retevisualisation.ViewportChangedListener;
import org.jamocha.application.gui.retevisualisation.VisualizerSetup;
import org.jamocha.engine.Engine;
import org.jamocha.engine.nodes.LeftInputAdaptorNode;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.TerminalNode;
import org.jamocha.engine.nodes.TwoInputNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visualizer
extends JComponent
implements ComponentListener,
MouseInputListener,
ViewportChangedListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    Node rootNode;
    VisualizerSetup setup;
    protected final Color betaColor = new Color(0, 0, 255, 120);
    protected final Color alphaColor = new Color(255, 0, 0, 120);
    protected final Color betaColorDeselected = new Color(0, 0, 255, 20);
    protected final Color alphaColorDeselected = new Color(255, 0, 0, 20);
    protected Map<Point, Node> point2node;
    protected Map<Node, Point> node2point;
    protected Map<Node, Boolean> isSelectedNode = new HashMap<Node, Boolean>();
    protected int logicalWidth = 0;
    protected int logicalHeight = 0;
    protected List<ViewportChangedListener> viewportChangedListener;
    protected boolean viewportChangeByClick = false;
    protected boolean autoScale = false;
    protected Map<Node, Integer> rowHints;
    protected boolean showSelection = false;
    protected Visualizer selectionRelativeTo;
    protected boolean pressed;
    protected ClickListener clickListener;
    protected Map<Node, List<String>> usedForRules;
    protected List<String> selectedRules = new ArrayList<String>();
    protected List<Node> selectedNodes;
    protected Point pressPos;
    protected int halfLineHeight = 20;
    protected Point offsetWhenPressed;
    protected int linestyle = 2;
    protected boolean rightScroll;

    public void computeRowHints() {
        this.rowHints.clear();
        int actLvl = 0;
        Stack<Node> activeLevel = new Stack<Node>();
        activeLevel.add(this.rootNode);
        while (!activeLevel.isEmpty()) {
            Stack<Node> nextLevel = new Stack<Node>();
            for (Node node : activeLevel) {
                this.rowHints.put(node, actLvl);
                for (Node child : node.getChildNodes()) {
                    nextLevel.push(child);
                }
            }
            ++actLvl;
            this.logicalWidth = Math.max(this.logicalWidth, activeLevel.size());
            activeLevel = nextLevel;
        }
        this.logicalHeight = actLvl;
    }

    public void reload() {
        this.computeRowHints();
        this.calculateSelectedNodes();
        this.componentResized2(null);
        this.node2point = new HashMap<Node, Point>();
        this.rootNode.getNodeDrawer().drawNode(0, this.selectedNodes, (Graphics2D)new BufferedImage(1, 1, 1).getGraphics(), this.setup, this.node2point, this.point2node, this.rowHints, this.halfLineHeight);
    }

    public void addViewportChangedListener(ViewportChangedListener listener) {
        this.viewportChangedListener.add(listener);
    }

    protected void callViewportChangedListeners() {
        ViewportChangeEvent e = new ViewportChangeEvent();
        e.x = -this.setup.offsetX;
        e.y = -this.setup.offsetY;
        e.width = (int)((float)this.getWidth() / this.setup.scaleX);
        e.height = (int)((float)this.getHeight() / this.setup.scaleY);
        this.callViewportChangedListeners(e);
    }

    protected void callViewportChangedListeners(ViewportChangeEvent e) {
        for (ViewportChangedListener listener : this.viewportChangedListener) {
            listener.viewportChanged(e);
        }
    }

    public void setLineStyle(int style) {
        this.linestyle = style;
        this.repaint();
    }

    public int getLineStyle() {
        return this.linestyle;
    }

    public Visualizer(Engine e) {
        this.rootNode = e.getNet().getRoot();
        this.setup = new VisualizerSetup();
        this.point2node = new HashMap<Point, Node>();
        this.rowHints = new HashMap<Node, Integer>();
        this.viewportChangedListener = new ArrayList<ViewportChangedListener>();
        this.usedForRules = new HashMap<Node, List<String>>();
        this.reload();
        this.addComponentListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    protected Point toPhysical(Point p, VisualizerSetup setup) {
        assert (p != null);
        Point result = new Point(p);
        result.x *= 44;
        result.x += 44;
        result.y *= 49;
        result.y += 24;
        result.x += setup.offsetX;
        result.y += setup.offsetY;
        result.x = (int)((float)result.x * setup.scaleX);
        result.y = (int)((float)result.y * setup.scaleY);
        return result;
    }

    protected int atan4(double y, double x) {
        double result = Math.atan2(y, x);
        if ((result = result * 180.0 / Math.PI) < 0.0) {
            result += 360.0;
        }
        if (result > 360.0) {
            result -= 360.0;
        }
        return (int)result;
    }

    protected List<String> calculateSelectedNodesHelper(Node node) {
        ArrayList<String> result = new ArrayList<String>();
        if (node instanceof TerminalNode) {
            TerminalNode n = (TerminalNode)node;
            result.add(n.getRule().getName());
        } else {
            for (Node child : node.getChildNodes()) {
                List<String> childResult = this.calculateSelectedNodesHelper(child);
                result.addAll(childResult);
            }
        }
        this.usedForRules.put(node, result);
        return result;
    }

    protected void calculateSelectedNodes() {
        this.calculateSelectedNodesHelper(this.rootNode);
        this.selectedNodes = new ArrayList<Node>();
        Stack<Node> nodes = new Stack<Node>();
        nodes.add(this.rootNode);
        while (!nodes.isEmpty()) {
            Node act = (Node)nodes.pop();
            for (Node child : act.getChildNodes()) {
                nodes.add(child);
            }
            if (!this.isNodeSelected(act)) continue;
            this.selectedNodes.add(act);
        }
    }

    public boolean isNodeSelected(Node node) {
        List<String> rules = this.usedForRules.get(node);
        for (String noderule : rules) {
            for (String selected : this.selectedRules) {
                if (!noderule.equals(selected)) continue;
                return true;
            }
        }
        return false;
    }

    protected void setSelectedRules(List<String> selected) {
        this.selectedRules = selected;
        this.calculateSelectedNodes();
        this.repaint();
    }

    protected void drawConnectionLines(Node root, Map<Node, Point> positions, Graphics2D canvas, boolean selected, boolean unselected) {
        for (Node child : root.getChildNodes()) {
            Point childPos = positions.get(child);
            Point rootPos = positions.get(root);
            if (childPos == null || rootPos == null) {
                this.reload();
                return;
            }
            rootPos = this.toPhysical(rootPos, this.setup);
            childPos = this.toPhysical(childPos, this.setup);
            if (this.isNodeSelected(child) && selected || !this.isNodeSelected(child) && unselected) {
                if (this.isNodeSelected(child)) {
                    if (root instanceof TwoInputNode || root instanceof LeftInputAdaptorNode) {
                        canvas.setColor(this.betaColor);
                    } else {
                        canvas.setColor(this.alphaColor);
                    }
                } else if (root instanceof TwoInputNode || root instanceof LeftInputAdaptorNode) {
                    canvas.setColor(this.betaColorDeselected);
                } else {
                    canvas.setColor(this.alphaColorDeselected);
                }
                if (this.linestyle == 2) {
                    int arcY;
                    int arcX;
                    int midY;
                    int midX;
                    int h;
                    rootPos = childPos.x == rootPos.x ? root.getNodeDrawer().getVerticalEndPoint(childPos, rootPos, this.setup) : root.getNodeDrawer().getHorizontalEndPoint(childPos, rootPos, this.setup);
                    childPos = childPos.y == rootPos.y ? child.getNodeDrawer().getHorizontalEndPoint(rootPos, childPos, this.setup) : child.getNodeDrawer().getVerticalEndPoint(rootPos, childPos, this.setup);
                    int w = Math.abs(rootPos.x - childPos.x);
                    if (rootPos.y < childPos.y) {
                        h = childPos.y - rootPos.y;
                        midX = rootPos.x;
                        midY = childPos.y;
                        arcX = midX - w;
                        arcY = midY - h;
                    } else {
                        h = -childPos.y + rootPos.y;
                        midY = rootPos.y;
                        midX = childPos.x;
                        arcX = midX - w;
                        arcY = midY - h;
                    }
                    h *= 2;
                    w *= 2;
                    int originToRootX = rootPos.x - midX;
                    int originToRootY = rootPos.y - midY;
                    int originToChildX = childPos.x - midX;
                    int originToChildY = childPos.y - midY;
                    int startAngle = this.atan4(-originToRootY, originToRootX);
                    int arcAngle = this.atan4(-originToChildY, originToChildX) - startAngle;
                    canvas.drawArc(arcX, arcY, w, h, startAngle, arcAngle);
                } else if (this.linestyle == 1) {
                    rootPos = root.getNodeDrawer().getLineEndPoint(childPos, rootPos, this.setup);
                    childPos = child.getNodeDrawer().getLineEndPoint(rootPos, childPos, this.setup);
                    canvas.drawLine(rootPos.x, rootPos.y, childPos.x, childPos.y);
                }
                double angle = Math.atan2(childPos.y - rootPos.y, childPos.x - rootPos.x);
                this.drawArrowHead(childPos.x, childPos.y, angle, canvas);
            }
            this.drawConnectionLines(child, positions, canvas, selected, unselected);
        }
    }

    protected void drawArrowHead(int x, int y, double angle, Graphics2D canvas) {
        int width = (int)(8.0f * this.setup.scaleX);
        int height = (int)(8.0f * this.setup.scaleY);
        canvas.fillOval(x - width / 2, y - width / 2, width + 1, height + 1);
    }

    protected void loadGoodFont(Graphics2D g) {
        int allowedHeight = (int)((double)(24.0f * this.setup.scaleY) * 0.9);
        int dpi = this.getToolkit().getScreenResolution();
        double allowedInches = (double)allowedHeight / (double)dpi;
        double allowedPoints = allowedInches * 72.0;
        Font goodFont = new Font("Helvetica", 1, (int)allowedPoints);
        g.setFont(goodFont);
        this.halfLineHeight = allowedHeight / 2;
    }

    @Override
    public void paint(Graphics g) {
        this.point2node.clear();
        Graphics2D canvas = (Graphics2D)g;
        canvas.setColor(Color.white);
        canvas.fillRect(0, 0, this.getWidth(), this.getHeight());
        BasicStroke widthOneStroke = new BasicStroke(1.0f * this.setup.scaleX);
        canvas.setStroke(widthOneStroke);
        canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawConnectionLines(this.rootNode, this.node2point, canvas, false, true);
        this.loadGoodFont(canvas);
        this.rootNode.getNodeDrawer().drawNode(0, this.selectedNodes, canvas, this.setup, this.node2point, this.point2node, this.rowHints, this.halfLineHeight);
        canvas.setStroke(widthOneStroke);
        this.drawConnectionLines(this.rootNode, this.node2point, canvas, true, false);
        if (this.showSelection) {
            VisualizerSetup s = this.selectionRelativeTo.setup;
            int x = (int)(((float)(-s.offsetX) + (float)this.selectionRelativeTo.getWidth() / s.scaleX / 2.0f) * this.setup.scaleX);
            int y = (int)(((float)(-s.offsetY) + (float)this.selectionRelativeTo.getHeight() / s.scaleY / 2.0f) * this.setup.scaleY);
            int w = (int)((float)this.selectionRelativeTo.getWidth() / s.scaleX * this.setup.scaleX);
            int h = (int)((float)this.selectionRelativeTo.getHeight() / s.scaleY * this.setup.scaleY);
            g.setColor(new Color(100, 100, 255, 100));
            g.fillRect(x - w / 2, y - h / 2, w + 1, h + 1);
        }
    }

    public void enableShowSelection(boolean enable) {
        this.showSelection = enable;
        this.repaint();
    }

    protected Point getLogicalPosition(int x, int y) {
        Point result = new Point();
        x = (int)((float)x / this.setup.scaleX);
        y = (int)((float)y / this.setup.scaleY);
        result.y = (y -= this.setup.offsetY) / 49;
        result.x = (x -= this.setup.offsetX) / 44;
        return result;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int y;
        int x = event.getX();
        Node node = this.point2node.get(this.getLogicalPosition(x, y = event.getY()));
        if (node == null) {
            return null;
        }
        return "<html>" + node.toString().replace("\n", "<br>") + "</html>";
    }

    public void enableToolTips(boolean enable) {
        if (enable) {
            this.setToolTipText(" ");
        } else {
            this.setToolTipText(null);
        }
    }

    public void enableAutoScale(boolean enable) {
        this.autoScale = enable;
    }

    public void componentResized2(ComponentEvent arg0) {
        if (this.autoScale) {
            int w = this.getWidth();
            int h = this.getHeight();
            int graphWidth = this.logicalWidth * 89;
            int graphHeight = this.logicalHeight * 49;
            double scaleW = (double)w / (double)graphWidth;
            double scaleH = (double)h / (double)graphHeight;
            this.setup.scaleX = this.setup.scaleY = (float)Math.min(scaleW, scaleH);
            if ((double)this.setup.scaleX == 0.0) {
                this.setup.scaleY = 1.0f;
                this.setup.scaleX = 1.0f;
            }
            this.repaint();
        }
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.componentResized2(arg0);
        this.callViewportChangedListeners();
    }

    public void enableViewportByClick(boolean enable, Visualizer other) {
        this.viewportChangeByClick = enable;
        this.selectionRelativeTo = other;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected void changeViewport(MouseEvent ev) {
        if (ev.getButton() != 1) {
            return;
        }
        double x = ev.getX();
        double y = ev.getY();
        x /= (double)this.setup.scaleX;
        y /= (double)this.setup.scaleY;
        if (!this.autoScale) {
            x -= (double)this.setup.offsetX;
            y -= (double)this.setup.offsetY;
        }
        double normalizedWidth = (float)this.selectionRelativeTo.getWidth() / this.selectionRelativeTo.setup.scaleX;
        double normalizedHeight = (float)this.selectionRelativeTo.getHeight() / this.selectionRelativeTo.setup.scaleY;
        this.setup.offsetX = (int)(x -= normalizedWidth / 2.0);
        this.setup.offsetY = (int)(y -= normalizedHeight / 2.0);
    }

    protected void _changeVP(int x, int y) {
        ViewportChangeEvent ev = new ViewportChangeEvent();
        x = (int)((float)x - (float)this.selectionRelativeTo.getWidth() / this.selectionRelativeTo.setup.scaleX * this.setup.scaleX / 2.0f);
        y = (int)((float)y - (float)this.selectionRelativeTo.getHeight() / this.selectionRelativeTo.setup.scaleY * this.setup.scaleY / 2.0f);
        ev.x = (int)(-((float)x / this.setup.scaleX));
        ev.y = (int)(-((float)y / this.setup.scaleY));
        this.callViewportChangedListeners(ev);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            if (this.viewportChangeByClick) {
                this._changeVP(arg0.getX(), arg0.getY());
            } else {
                int y;
                int x = arg0.getX();
                Node node = this.point2node.get(this.getLogicalPosition(x, y = arg0.getY()));
                if (node != null) {
                    String description = node.toString();
                    this.clickListener.nodeClicked(description);
                }
            }
        } else if (arg0.getButton() == 2) {
            float margin = 5.0f;
            Point lp = this.node2point.get(this.point2node.get(this.getLogicalPosition(arg0.getX(), arg0.getY())));
            int midX = 12 + lp.x * 89 / 2 + 32;
            int midY = 12 + lp.y * 49 + 12;
            float scaleX = (float)this.getWidth() / 320.0f;
            float scaleY = (float)this.getHeight() / 120.0f;
            float scale = Math.min(scaleX, scaleY);
            midX = (int)((float)midX - (float)this.getWidth() / scale / 2.0f);
            midY = (int)((float)midY - (float)this.getHeight() / scale / 2.0f);
            this.setup.scaleX = scale;
            this.setup.scaleY = scale;
            this.setup.offsetX = -midX;
            this.setup.offsetY = -midY;
            this.correctOffsets();
            this.callViewportChangedListeners();
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.pressPos = arg0.getPoint();
        this.offsetWhenPressed = new Point(this.setup.offsetX, this.setup.offsetY);
        if (!this.viewportChangeByClick && arg0.getButton() == 3) {
            this.rightScroll = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.rightScroll = false;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (this.viewportChangeByClick) {
            this._changeVP(arg0.getX(), arg0.getY());
        } else if (this.rightScroll) {
            int altOffX = this.offsetWhenPressed.x;
            int altOffY = this.offsetWhenPressed.y;
            int offsetOffsetX = arg0.getPoint().x - this.pressPos.x;
            int offsetOffsetY = arg0.getPoint().y - this.pressPos.y;
            offsetOffsetX = (int)((float)offsetOffsetX / this.setup.scaleX);
            offsetOffsetY = (int)((float)offsetOffsetY / this.setup.scaleY);
            this.setup.offsetX = altOffX + offsetOffsetX;
            this.setup.offsetY = altOffY + offsetOffsetY;
            this.correctOffsets();
            this.repaint();
            this.callViewportChangedListeners();
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    protected void correctOffsets() {
        int maxOffsetX = (int)((float)(-this.logicalWidth * 89) + (float)this.getWidth() / this.setup.scaleX);
        int maxOffsetY = (int)((float)(-this.logicalHeight * 49) + (float)this.getHeight() / this.setup.scaleY);
        if (this.setup.offsetX < maxOffsetX) {
            this.setup.offsetX = maxOffsetX;
        }
        if (this.setup.offsetY < maxOffsetY) {
            this.setup.offsetY = maxOffsetY;
        }
        if (this.setup.offsetX > 0) {
            this.setup.offsetX = 0;
        }
        if (this.setup.offsetY > 0) {
            this.setup.offsetY = 0;
        }
    }

    @Override
    public void viewportChanged(ViewportChangeEvent e) {
        if (!this.autoScale) {
            this.setup.offsetX = e.x;
            this.setup.offsetY = e.y;
            this.correctOffsets();
        }
        this.repaint();
    }

    public void setClickListener(ClickListener cl) {
        this.clickListener = cl;
    }

    protected void zoom(double valueX, double valueY) {
        int midX = (int)((double)(-this.setup.offsetX) + (double)((float)this.getWidth() / this.setup.scaleX) / 2.0);
        int midY = (int)((double)(-this.setup.offsetY) + (double)((float)this.getHeight() / this.setup.scaleY) / 2.0);
        this.setup.scaleX = (float)valueX;
        this.setup.scaleY = (float)valueY;
        if ((double)this.setup.scaleX < 0.1) {
            this.setup.scaleX = 0.1f;
        }
        if ((double)this.setup.scaleY < 0.1) {
            this.setup.scaleY = 0.1f;
        }
        if (this.setup.scaleX > 10.0f) {
            this.setup.scaleX = 10.0f;
        }
        if (this.setup.scaleY > 10.0f) {
            this.setup.scaleY = 10.0f;
        }
        this.setup.offsetX = (int)((double)(-midX) + (double)((float)this.getWidth() / this.setup.scaleX) / 2.0);
        this.setup.offsetY = (int)((double)(-midY) + (double)((float)this.getHeight() / this.setup.scaleY) / 2.0);
        this.correctOffsets();
    }

    protected void zoom(double valueX, double valueY, boolean relative) {
        if (relative) {
            this.zoom(valueX * (double)this.setup.scaleX, valueY * (double)this.setup.scaleY);
        } else {
            this.zoom(valueX, valueY);
        }
        this.callViewportChangedListeners();
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        if (this.autoScale) {
            return;
        }
        int dir = arg0.getWheelRotation();
        double d = 1.0;
        d = dir > 0 ? 1.1 : 0.9;
        this.zoom(d, d, true);
    }
}

