/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jamocha.application.gui.editor.AbstractJamochaEditor;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.engine.modules.Module;
import org.jamocha.parser.JamochaType;

public class TemplateEditor
extends AbstractJamochaEditor
implements ActionListener {
    private static final long serialVersionUID = 6037731034903564707L;
    private final JPanel contentPanel;
    private JPanel templatePanel;
    private final JButton addSlotButton;
    private final JButton cancelButton;
    private final JButton assertButton;
    private final JTextField nameField;
    private final JComboBox moduleBox;
    private final JButton reloadButtonDumpAreaTemplate;
    private final JTextArea dumpAreaTemplate = new JTextArea();
    private StringChannel channel;
    private GridBagLayout gridbag;
    private GridBagConstraints gridbagConstraints;
    private final List<EditorRow> rows = new LinkedList<EditorRow>();

    public TemplateEditor(Engine engine) {
        super(engine);
        this.setSize(600, 500);
        this.setLayout(new BorderLayout());
        this.setTitle("Create new Template");
        this.contentPanel = new JPanel(new BorderLayout());
        this.add((Component)this.contentPanel, "Center");
        this.cancelButton = new JButton("Cancel", IconLoader.getImageIcon("cancel"));
        this.cancelButton.addActionListener(this);
        this.assertButton = new JButton("Create Template", IconLoader.getImageIcon("brick_add"));
        this.assertButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 5, 1));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.assertButton);
        this.add((Component)buttonPanel, "South");
        this.nameField = new JTextField(15);
        Collection<Module> modules = engine.getModules().getModuleList();
        String[] moduleNames = new String[modules.size()];
        int i = 0;
        for (Module mod : modules) {
            moduleNames[i++] = mod.getName();
        }
        this.moduleBox = new JComboBox<String>(moduleNames);
        this.addSlotButton = new JButton("Add Slot", IconLoader.getImageIcon("add"));
        this.addSlotButton.addActionListener(this);
        this.addSlotButton.setAlignmentX(1.0f);
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createTitledBorder("General Template Settings"));
        topPanel.setLayout(new FlowLayout(0, 20, 1));
        JPanel innerTopPanel = new JPanel(new GridLayout(2, 2));
        innerTopPanel.add(new JLabel("Template-name:"));
        innerTopPanel.add(this.nameField);
        innerTopPanel.add(new JLabel("Template-Module:"));
        innerTopPanel.add(this.moduleBox);
        topPanel.add((Component)innerTopPanel, "West");
        topPanel.add(this.addSlotButton);
        this.add((Component)topPanel, "North");
        this.dumpAreaTemplate.setEditable(false);
        this.dumpAreaTemplate.setFont(new Font("Courier", 0, 12));
        this.dumpAreaTemplate.setRows(5);
        JPanel dumpAreaPanel = new JPanel();
        dumpAreaPanel.setLayout(new BoxLayout(dumpAreaPanel, 1));
        dumpAreaPanel.setBorder(BorderFactory.createTitledBorder("Template Preview"));
        dumpAreaPanel.add(new JScrollPane(this.dumpAreaTemplate));
        this.reloadButtonDumpAreaTemplate = new JButton("Reload Template Preview", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButtonDumpAreaTemplate.addActionListener(this);
        dumpAreaPanel.add(this.reloadButtonDumpAreaTemplate);
        this.contentPanel.add((Component)dumpAreaPanel, "South");
    }

    public void setStringChannel(StringChannel channel) {
        this.channel = channel;
    }

    public void init() {
        this.templatePanel = new JPanel();
        this.templatePanel.setBorder(BorderFactory.createTitledBorder("Set the Slots for the Template"));
        this.contentPanel.add((Component)new JScrollPane(this.templatePanel), "Center");
        this.initTemplatePanel();
        this.setVisible(true);
    }

    private void initTemplatePanel() {
        this.gridbag = new GridBagLayout();
        this.gridbagConstraints = new GridBagConstraints();
        this.gridbagConstraints.weightx = 1.0;
        this.templatePanel.setLayout(this.gridbag);
        this.gridbagConstraints.anchor = 17;
        this.gridbagConstraints.gridx = 0;
        this.gridbagConstraints.gridy = 0;
        this.templatePanel.add(new JLabel());
        this.gridbagConstraints.gridx = 1;
        this.templatePanel.add(new JLabel());
        this.gridbagConstraints.gridy = 2;
        this.templatePanel.add(new JLabel("Type:"));
        this.gridbagConstraints.gridy = 3;
        this.templatePanel.add(new JLabel("Name:"));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.assertButton) {
            this.channel.executeCommand(this.getCurrentDeftemplateString(false));
            JOptionPane.showMessageDialog(this, "Template created.\nPlease check the log for Messages.");
        } else if (event.getSource() == this.cancelButton) {
            this.close();
        } else if (event.getSource() == this.reloadButtonDumpAreaTemplate) {
            this.dumpAreaTemplate.setText(this.getCurrentDeftemplateString(true));
        } else if (event.getSource() == this.addSlotButton) {
            EditorRow row = new EditorRow(new DeleteButton(IconLoader.getImageIcon("delete"), this.rows.size()), new JLabel("Slot " + (this.rows.size() + 1)), this.getNewTypesCombo(), new JTextField());
            row.deleteButton.addActionListener(this);
            this.addRemoveButton(this.templatePanel, row.deleteButton, this.gridbag, this.gridbagConstraints, this.rows.size() + 1);
            this.addLabel(this.templatePanel, row.rowLabel, this.gridbag, this.gridbagConstraints, this.rows.size() + 1);
            this.addTypesCombo(this.templatePanel, row.typeBox, this.gridbag, this.gridbagConstraints, this.rows.size() + 1);
            this.addNameField(this.templatePanel, row.nameField, this.gridbag, this.gridbagConstraints, this.rows.size() + 1);
            this.rows.add(row);
            this.templatePanel.revalidate();
        } else if (event.getSource() instanceof DeleteButton) {
            DeleteButton deleteButton = (DeleteButton)event.getSource();
            this.rows.remove(deleteButton.getRow());
            this.templatePanel.removeAll();
            this.initTemplatePanel();
            for (int i = 0; i < this.rows.size(); ++i) {
                EditorRow editorRow = this.rows.get(i);
                editorRow.deleteButton.setRow(i);
                editorRow.rowLabel.setText("Slot " + (i + 1));
                this.addRemoveButton(this.templatePanel, editorRow.deleteButton, this.gridbag, this.gridbagConstraints, i + 1);
                this.addLabel(this.templatePanel, editorRow.rowLabel, this.gridbag, this.gridbagConstraints, i + 1);
                this.addTypesCombo(this.templatePanel, editorRow.typeBox, this.gridbag, this.gridbagConstraints, i + 1);
                this.addNameField(this.templatePanel, editorRow.nameField, this.gridbag, this.gridbagConstraints, i + 1);
            }
            this.templatePanel.repaint();
            this.templatePanel.revalidate();
        }
    }

    private String getCurrentDeftemplateString(boolean print) {
        StringBuilder res = new StringBuilder("(deftemplate " + this.moduleBox.getSelectedItem() + "::" + this.nameField.getText());
        if (print) {
            res.append("\n");
        }
        for (EditorRow row : this.rows) {
            res.append("    (");
            if (row.typeBox.getSelectedItem().toString().equals(JamochaType.LIST.toString())) {
                res.append("multislot " + row.nameField.getText() + ")");
            } else {
                res.append("slot " + row.nameField.getText());
                if (!row.typeBox.getSelectedItem().equals("UNDEFINED")) {
                    if (print) {
                        res.append("\n");
                    }
                    res.append("        (type " + row.typeBox.getSelectedItem().toString() + ")");
                    if (print) {
                        res.append("\n    ");
                    }
                }
                res.append(")");
            }
            if (!print) continue;
            res.append("\n");
        }
        res.append(")");
        return res.toString();
    }

    private void addRemoveButton(JPanel parent, JButton button, GridBagLayout gridbag, GridBagConstraints c, int row) {
        c.gridx = 0;
        c.gridy = row;
        c.fill = 0;
        c.anchor = 13;
        gridbag.setConstraints(button, c);
        parent.add(button);
    }

    private void addLabel(JPanel parent, JLabel label, GridBagLayout gridbag, GridBagConstraints c, int row) {
        c.gridx = 1;
        c.gridy = row;
        c.fill = 0;
        c.anchor = 13;
        gridbag.setConstraints(label, c);
        parent.add(label);
    }

    private void addTypesCombo(JPanel parent, JComboBox combo, GridBagLayout gridbag, GridBagConstraints c, int row) {
        c.gridx = 2;
        c.gridy = row;
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(combo, c);
        parent.add(combo);
    }

    private void addNameField(JPanel parent, JTextField field, GridBagLayout gridbag, GridBagConstraints c, int row) {
        c.gridx = 3;
        c.gridy = row;
        c.fill = 2;
        c.anchor = 17;
        field.setColumns(30);
        gridbag.setConstraints(field, c);
        parent.add(field);
    }

    private JComboBox getNewTypesCombo() {
        String[] types = new String[]{"UNDEFINED", "STRING", "BOOLEAN", "LONG", "DOUBLE", "LIST", "OBJECT", "FACT"};
        JComboBox<String> box = new JComboBox<String>(types);
        return box;
    }

    private class DeleteButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private int row;

        private DeleteButton(ImageIcon icon, int row) {
            super(icon);
            this.row = row;
        }

        private int getRow() {
            return this.row;
        }

        private void setRow(int row) {
            this.row = row;
        }
    }

    private class EditorRow {
        private final DeleteButton deleteButton;
        private final JLabel rowLabel;
        private final JComboBox typeBox;
        private final JTextField nameField;

        private EditorRow(DeleteButton deleteButton, JLabel rowLabel, JComboBox typeBox, JTextField nameField) {
            this.deleteButton = deleteButton;
            this.rowLabel = rowLabel;
            this.typeBox = typeBox;
            this.nameField = nameField;
        }
    }
}

