/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jamocha.application.gui.editor.AbstractJamochaEditor;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.JamochaType;

public class FactEditor
extends AbstractJamochaEditor
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 6037731034903564707L;
    private int step = 0;
    private final JPanel contentPanel;
    private final JButton cancelButton;
    private final JButton assertButton;
    private final JButton backButton;
    private final JButton nextButton;
    private JButton reloadButtondumpAreaFact;
    private JList moduleList;
    private JList templateList;
    private final JTextArea dumpAreaTemplate = new JTextArea();
    private final JTextArea dumpAreaFact = new JTextArea();
    private final DefaultListModel moduleListModel = new DefaultListModel();
    private final DefaultListModel templateListModel = new DefaultListModel();
    private StringChannel channel;
    private final Map<TemplateSlot, JComponent> factComponents = new HashMap<TemplateSlot, JComponent>();

    public FactEditor(Engine engine) {
        super(engine);
        this.setLayout(new BorderLayout());
        this.setTitle("Assert new Fact");
        this.contentPanel = new JPanel(new CardLayout());
        this.add((Component)this.contentPanel, "Center");
        this.cancelButton = new JButton("Cancel", IconLoader.getImageIcon("cancel"));
        this.cancelButton.addActionListener(this);
        this.assertButton = new JButton("Assert Fact", IconLoader.getImageIcon("database_add"));
        this.assertButton.addActionListener(this);
        this.assertButton.setVisible(false);
        this.backButton = new JButton("Back", IconLoader.getImageIcon("resultset_previous"));
        this.backButton.addActionListener(this);
        this.backButton.setVisible(false);
        this.nextButton = new JButton("Next", IconLoader.getImageIcon("resultset_next"));
        this.nextButton.setHorizontalTextPosition(2);
        this.nextButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 5, 1));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.backButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.assertButton);
        this.add((Component)buttonPanel, "Last");
        this.dumpAreaTemplate.setEditable(false);
        this.dumpAreaTemplate.setFont(new Font("Courier", 0, 12));
        this.dumpAreaTemplate.setRows(5);
        this.dumpAreaFact.setEditable(false);
        this.dumpAreaFact.setFont(new Font("Courier", 0, 12));
        this.dumpAreaFact.setRows(5);
    }

    public void setStringChannel(StringChannel channel) {
        this.channel = channel;
    }

    public void init() {
        this.initPreselectionPanel();
        this.initFactEditPanel();
        this.showCurrentStep();
        this.setVisible(true);
    }

    private void initPreselectionPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel preselectionPanel = new JPanel(gridbag);
        c.fill = 1;
        this.moduleList = new JList(this.moduleListModel);
        this.moduleList.setSelectionMode(0);
        this.moduleList.getSelectionModel().addListSelectionListener(this);
        Collection<Module> modules = this.engine.getModules().getModuleList();
        for (Module mod : modules) {
            this.moduleListModel.addElement(mod.getName());
        }
        JPanel modulePanel = new JPanel();
        modulePanel.setLayout(new BoxLayout(modulePanel, 1));
        modulePanel.add(new JLabel("Select a Module:"));
        modulePanel.add(new JScrollPane(this.moduleList));
        c.weightx = 0.5;
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 1.0;
        gridbag.setConstraints(modulePanel, c);
        preselectionPanel.add(modulePanel);
        this.templateList = new JList(this.templateListModel);
        this.templateList.setSelectionMode(0);
        this.templateList.getSelectionModel().addListSelectionListener(this);
        this.initTemplateList();
        JPanel templatePanel = new JPanel();
        templatePanel.setLayout(new BoxLayout(templatePanel, 1));
        templatePanel.add(new JLabel("Select a Template:"));
        templatePanel.add(new JScrollPane(this.templateList));
        c.gridx = 1;
        gridbag.setConstraints(templatePanel, c);
        preselectionPanel.add(templatePanel);
        JPanel dumpAreaPanel = new JPanel();
        dumpAreaPanel.setLayout(new BoxLayout(dumpAreaPanel, 1));
        dumpAreaPanel.setBorder(BorderFactory.createTitledBorder("Template Definition"));
        dumpAreaPanel.add(new JScrollPane(this.dumpAreaTemplate));
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        gridbag.setConstraints(dumpAreaPanel, c);
        preselectionPanel.add(dumpAreaPanel);
        this.contentPanel.add((Component)preselectionPanel, "preselection");
    }

    private void initTemplateList() {
        this.templateListModel.clear();
        String selected = String.valueOf(this.moduleList.getSelectedValue());
        Module module = this.engine.getModules().findModule(selected);
        if (module != null) {
            List<Template> templates = module.getTemplates();
            Iterator<Template> i$ = templates.iterator();
            while (i$.hasNext()) {
                Template obj;
                Template tmp = obj = i$.next();
                if (module.getName().equals("MAIN") && tmp.getName().equals("_initialFact")) continue;
                this.templateListModel.addElement(tmp.getName());
            }
        }
    }

    private void initFactEditPanel() {
        this.factComponents.clear();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel factEditPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(gridbag);
        factEditPanel.setBorder(BorderFactory.createTitledBorder("Set the Slots for the Fact"));
        if (this.templateList.getSelectedIndex() > -1) {
            Module module = this.engine.getModules().findModule(String.valueOf(this.moduleList.getSelectedValue()));
            Template tmp = module.getTemplate(String.valueOf(this.templateList.getSelectedValue()));
            c.weightx = 1.0;
            TemplateSlot[] slots = tmp.getAllSlots();
            for (int i = 0; i < slots.length; ++i) {
                c.gridx = 0;
                c.gridy = i;
                c.fill = 3;
                c.anchor = 13;
                JLabel label = new JLabel(slots[i].getName() + ": ");
                gridbag.setConstraints(label, c);
                innerPanel.add(label);
                c.gridx = 1;
                c.fill = 1;
                c.anchor = 17;
                if (slots[i].isMultiSlot()) {
                    MultiSlotEditor multislotEditor = new MultiSlotEditor();
                    JScrollPane scrollPane = new JScrollPane(multislotEditor.getList());
                    gridbag.setConstraints(scrollPane, c);
                    innerPanel.add(scrollPane);
                    this.factComponents.put(slots[i], multislotEditor.getList());
                    continue;
                }
                if (slots[i].getValueType() == JamochaType.FACT) {
                    JComboBox factBox = new JComboBox();
                    this.factComponents.put(slots[i], factBox);
                    continue;
                }
                JTextField textField = new JTextField();
                gridbag.setConstraints(textField, c);
                innerPanel.add(textField);
                this.factComponents.put(slots[i], textField);
            }
        }
        factEditPanel.add((Component)new JScrollPane(innerPanel), "Center");
        JPanel dumpAreaPanel = new JPanel();
        dumpAreaPanel.setLayout(new BoxLayout(dumpAreaPanel, 1));
        dumpAreaPanel.setBorder(BorderFactory.createTitledBorder("Fact Preview"));
        dumpAreaPanel.add(new JScrollPane(this.dumpAreaFact));
        this.reloadButtondumpAreaFact = new JButton("Reload Fact Preview", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButtondumpAreaFact.addActionListener(this);
        dumpAreaPanel.add(this.reloadButtondumpAreaFact);
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        gridbag.setConstraints(dumpAreaPanel, c);
        factEditPanel.add((Component)dumpAreaPanel, "South");
        this.contentPanel.add("factEdit", factEditPanel);
    }

    private void showCurrentStep() {
        switch (this.step) {
            case 0: {
                ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "preselection");
                if (this.templateList.getSelectedIndex() > -1) {
                    this.nextButton.setEnabled(true);
                } else {
                    this.nextButton.setEnabled(false);
                }
                this.nextButton.setVisible(true);
                this.backButton.setVisible(false);
                this.assertButton.setVisible(false);
                this.nextButton.requestFocus();
                break;
            }
            case 1: {
                this.initFactEditPanel();
                ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "factEdit");
                this.nextButton.setVisible(false);
                this.backButton.setVisible(true);
                this.assertButton.setVisible(true);
                this.assertButton.requestFocus();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.assertButton) {
            this.channel.executeCommand(this.getCurrentFactAssertionString(false));
            JOptionPane.showMessageDialog(this, "Assertion done.\nPlease check the log for Messages.");
        } else if (event.getSource() == this.backButton) {
            if (this.step > 0) {
                --this.step;
                this.showCurrentStep();
            }
        } else if (event.getSource() == this.nextButton) {
            if (this.step < 1) {
                ++this.step;
                this.showCurrentStep();
            }
        } else if (event.getSource() == this.cancelButton) {
            this.close();
        } else if (event.getSource() == this.reloadButtondumpAreaFact) {
            this.dumpAreaFact.setText(this.getCurrentFactAssertionString(true));
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.moduleList.getSelectionModel()) {
            this.initTemplateList();
        } else if (event.getSource() == this.templateList.getSelectionModel()) {
            if (this.templateList.getSelectedIndex() > -1) {
                TemplateSlot[] slots;
                this.nextButton.setEnabled(true);
                Module module = this.engine.getModules().findModule(String.valueOf(this.moduleList.getSelectedValue()));
                Template tmp = module.getTemplate(String.valueOf(this.templateList.getSelectedValue()));
                this.dumpAreaTemplate.setText("(deftemplate " + tmp.getName() + "\n");
                for (TemplateSlot slot : slots = tmp.getAllSlots()) {
                    this.dumpAreaTemplate.append("    (");
                    if (slot.isMultiSlot()) {
                        this.dumpAreaTemplate.append("multislot " + slot.getName() + ")");
                    } else {
                        this.dumpAreaTemplate.append("slot " + slot.getName());
                        if (slot.getValueType() != JamochaType.UNDEFINED) {
                            this.dumpAreaTemplate.append("\n");
                            this.dumpAreaTemplate.append("        (type " + slot.getValueType().toString() + ")");
                            this.dumpAreaTemplate.append("\n    ");
                        }
                        this.dumpAreaTemplate.append(")");
                    }
                    this.dumpAreaTemplate.append("\n");
                }
                this.dumpAreaTemplate.append(")");
            } else {
                this.nextButton.setEnabled(false);
            }
        }
    }

    private String getCurrentFactAssertionString(boolean print) {
        Module module = this.engine.getModules().findModule(String.valueOf(this.moduleList.getSelectedValue()));
        Template tmp = module.getTemplate(String.valueOf(this.templateList.getSelectedValue()));
        StringBuilder res = new StringBuilder("(assert (" + tmp.getName());
        for (TemplateSlot slot : this.factComponents.keySet()) {
            JComponent currComponent = this.factComponents.get(slot);
            if (print) {
                res.append("\n\t");
            }
            res.append("(" + slot.getName() + " ");
            if (slot.isMultiSlot()) {
                Object[] values = ((DefaultListModel)((JList)currComponent).getModel()).toArray();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        res.append(" ");
                    }
                    res.append("\"" + values[i].toString() + "\"");
                }
            } else if (slot.getValueType() != JamochaType.FACT) {
                if (slot.getValueType() == JamochaType.STRING) {
                    res.append("\"" + ((JTextField)currComponent).getText() + "\"");
                } else {
                    res.append(((JTextField)currComponent).getText());
                }
            }
            res.append(")");
        }
        if (print) {
            res.append("\n");
        }
        res.append("))");
        return res.toString();
    }

    private final class MultiSlotEditor
    implements ActionListener,
    PopupMenuListener {
        private final JList list;
        private final DefaultListModel listModel = new DefaultListModel();
        private final JPopupMenu popupMenu = new JPopupMenu();
        private final JMenuItem addMenuItem = new JMenuItem("add value", IconLoader.getImageIcon("add"));
        private final JMenuItem editMenuItem;
        private final JMenuItem deleteMenuItem;

        private MultiSlotEditor() {
            this.addMenuItem.addActionListener(this);
            this.editMenuItem = new JMenuItem("edit value", IconLoader.getImageIcon("pencil"));
            this.editMenuItem.addActionListener(this);
            this.deleteMenuItem = new JMenuItem("remove value", IconLoader.getImageIcon("delete"));
            this.deleteMenuItem.addActionListener(this);
            this.popupMenu.add(this.addMenuItem);
            this.popupMenu.add(this.editMenuItem);
            this.popupMenu.add(this.deleteMenuItem);
            this.popupMenu.addPopupMenuListener(this);
            this.list = new JList(this.listModel);
            this.list.setVisibleRowCount(4);
            this.list.setComponentPopupMenu(this.popupMenu);
        }

        private JList getList() {
            return this.list;
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.addMenuItem) {
                String value = JOptionPane.showInputDialog("Enter the value:");
                this.listModel.addElement(value);
            } else if (event.getSource() == this.editMenuItem) {
                String value = JOptionPane.showInputDialog("Enter the value:", this.list.getSelectedValue());
                this.listModel.set(this.list.getSelectedIndex(), value);
            } else if (event.getSource() == this.deleteMenuItem) {
                int[] indices = this.list.getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    this.listModel.remove(indices[i]);
                }
            }
        }

        public void popupMenuCanceled(PopupMenuEvent arg0) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            this.addMenuItem.setVisible(true);
            if (this.list.getSelectedIndices().length > 1) {
                this.editMenuItem.setVisible(false);
                this.deleteMenuItem.setVisible(true);
            } else if (this.list.getSelectedIndices().length == 1) {
                this.editMenuItem.setVisible(true);
                this.deleteMenuItem.setVisible(true);
            } else {
                this.editMenuItem.setVisible(false);
                this.deleteMenuItem.setVisible(false);
            }
        }
    }
}

