/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jamocha.application.gui.BrowserControl;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.settings.JamochaSettings;

public class JamochaMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 2908247560107956066L;
    private final JamochaGui gui;
    private final JMenu fileMenu;
    private final JMenuItem fileMenuBatch;
    private final JMenuItem fileMenuCloseGui;
    private final JMenuItem fileMenuQuit;
    private final JMenu helpMenu;
    private final JMenuItem helpMenuAbout;
    private final JMenuItem helpMenuDocu;
    private JDialog aboutDialog;

    public JamochaMenuBar(JamochaGui gui) {
        this.gui = gui;
        this.fileMenu = new JMenu("File");
        this.fileMenuBatch = new JMenuItem("Batch File ...", IconLoader.getImageIcon("lorry"));
        this.fileMenuBatch.addActionListener(this);
        this.fileMenuCloseGui = new JMenuItem("Close Gui", IconLoader.getImageIcon("disconnect"));
        this.fileMenuCloseGui.addActionListener(this);
        this.fileMenuQuit = new JMenuItem("Quit", IconLoader.getImageIcon("door_in"));
        this.fileMenuQuit.addActionListener(this);
        this.fileMenu.add(this.fileMenuBatch);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileMenuCloseGui);
        this.fileMenu.add(this.fileMenuQuit);
        this.add(this.fileMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenuDocu = new JMenuItem("Online Documentation", IconLoader.getImageIcon("help"));
        this.helpMenuDocu.addActionListener(this);
        this.helpMenuAbout = new JMenuItem("About", IconLoader.getImageIcon("comment"));
        this.helpMenuAbout.addActionListener(this);
        this.helpMenu.add(this.helpMenuDocu);
        this.helpMenu.add(this.helpMenuAbout);
        this.add(this.helpMenu);
    }

    public void showCloseGui(boolean show) {
        this.fileMenuCloseGui.setVisible(show);
    }

    public void showQuit(boolean show) {
        this.fileMenuQuit.setVisible(show);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.fileMenuQuit) {
            this.gui.setExitOnClose(true);
            this.gui.close();
        } else if (event.getSource() == this.fileMenuCloseGui) {
            this.gui.setExitOnClose(false);
            this.gui.close();
        } else if (event.getSource() == this.fileMenuBatch) {
            File file;
            JamochaSettings prefs = JamochaSettings.getInstance();
            JFileChooser chooser = new JFileChooser(prefs.getString("gui.menubar.batchLastPath"));
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null && file.isFile()) {
                prefs.set("gui.menubar.batchLastPath", file.getAbsolutePath());
                ArrayList<String> files = new ArrayList<String>(1);
                files.add(file.getPath());
                this.gui.processBatchFiles(files);
                JOptionPane.showMessageDialog(this, "Batch process started.\nPlease check the log for Messages.\nThe process might be running in the background for a while.");
            }
        } else if (event.getSource() == this.helpMenuDocu) {
            BrowserControl.displayURL("http://www.jamocha.org/wiki/pmwiki.php?n=Documentation.Documentation", this.gui);
        } else if (event.getSource() == this.helpMenuAbout) {
            String aboutText = "\u00a9 2007 by Jamocha Developer Group.\n\nVersion 0.9 Beta 9 (Schweinegulasch)\n\nJamocha is an open source rule engine released under the Apache Software License.\n\nFor more information visit http://www.jamocha.org\n\nCredits for the Icons used in the GUI go to Marc James (http://www.famfamfam.com/lab/icons/silk/). They are released under a Creative Commons Attribution 2.5 License.\n\nCredits for the Jamocha-Logo go to Frank R\u00fcttgers (http://www.xele.de).\n\nDevelopers (in alphabetical order):\n- Alexander Wilden\n- Ananda Sumadha Markus Widyadharma\n- Andreas Eberhart\n- Benjamin Zimmermann\n- Christian Ebert\n- Christoph Emonds\n- Emmanuel Bonnet\n- Josef-Alexander Hahn\n- Karl-Heinz Krempels\n- Martin Krebs\n- Michael Neale\n- Nikolaus Koemm\n- Ory Chowaw-Liebman\n- Peter Lin\n- Sebastian Reinartz\n- Sven Lilienthal\n- Tim Niemueller\n- Ulrich Loup\n- Volker Wetzelaer";
            this.aboutDialog = new JDialog(this.gui, "About Jamocha", true);
            this.aboutDialog.setLocationByPlatform(true);
            this.aboutDialog.setSize(500, 400);
            this.aboutDialog.setLayout(new BorderLayout());
            JPanel logoPanel = new JPanel(new FlowLayout(0));
            logoPanel.add(new JLabel(IconLoader.getImageIcon("jamocha")));
            logoPanel.add(new JLabel("one engine for all your rules"));
            this.aboutDialog.add((Component)logoPanel, "North");
            JTextArea aboutArea = new JTextArea("\u00a9 2007 by Jamocha Developer Group.\n\nVersion 0.9 Beta 9 (Schweinegulasch)\n\nJamocha is an open source rule engine released under the Apache Software License.\n\nFor more information visit http://www.jamocha.org\n\nCredits for the Icons used in the GUI go to Marc James (http://www.famfamfam.com/lab/icons/silk/). They are released under a Creative Commons Attribution 2.5 License.\n\nCredits for the Jamocha-Logo go to Frank R\u00fcttgers (http://www.xele.de).\n\nDevelopers (in alphabetical order):\n- Alexander Wilden\n- Ananda Sumadha Markus Widyadharma\n- Andreas Eberhart\n- Benjamin Zimmermann\n- Christian Ebert\n- Christoph Emonds\n- Emmanuel Bonnet\n- Josef-Alexander Hahn\n- Karl-Heinz Krempels\n- Martin Krebs\n- Michael Neale\n- Nikolaus Koemm\n- Ory Chowaw-Liebman\n- Peter Lin\n- Sebastian Reinartz\n- Sven Lilienthal\n- Tim Niemueller\n- Ulrich Loup\n- Volker Wetzelaer");
            aboutArea.setBorder(BorderFactory.createEmptyBorder());
            aboutArea.setLineWrap(true);
            aboutArea.setWrapStyleWord(true);
            aboutArea.setEditable(false);
            this.aboutDialog.add((Component)new JScrollPane(aboutArea, 22, 31), "Center");
            JPanel closePanel = new JPanel(new FlowLayout(2));
            JButton closeButton = new JButton("close");
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    JamochaMenuBar.this.aboutDialog.dispose();
                }
            });
            closePanel.add(closeButton);
            this.aboutDialog.add((Component)closePanel, "South");
            this.aboutDialog.setVisible(true);
        }
    }
}

